/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.deployment.plugin.factories.BaseDeploymentFactory;
import org.apache.geronimo.deployment.spi.ModuleConfigurer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

@GBean(j2eeType="DeploymentFactory")
public class DeploymentFactoryWithKernel
extends BaseDeploymentFactory {
    private final Kernel kernel;

    public DeploymentFactoryWithKernel(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        this.kernel = kernel;
        DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)this);
    }

    @Override
    protected Collection<ModuleConfigurer> getModuleConfigurers() throws DeploymentManagerCreationException {
        ArrayList<ModuleConfigurer> moduleConfigurers = new ArrayList<ModuleConfigurer>();
        Set<AbstractName> configurerNames = this.kernel.listGBeans(new AbstractNameQuery(ModuleConfigurer.class.getName()));
        for (AbstractName configurerName : configurerNames) {
            try {
                ModuleConfigurer configurer = (ModuleConfigurer)this.kernel.getGBean(configurerName);
                moduleConfigurers.add(configurer);
            }
            catch (GBeanNotFoundException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("No gbean found for name returned in query : " + configurerName)))).initCause(e));
            }
        }
        return moduleConfigurers;
    }
}

