/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.geronimo.system.plugin.model.ObjectFactory;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class PluginXmlUtil {
    public static final XMLInputFactory XMLINPUT_FACTORY = XMLInputFactory.newInstance();
    public static final JAXBContext PLUGIN_CONTEXT;
    public static final JAXBContext PLUGIN_LIST_CONTEXT;
    public static final JAXBContext PLUGIN_ARTIFACT_CONTEXT;
    private static final QName _PluginArtifact_QNAME;

    public static void writePluginMetadata(PluginType metadata, OutputStream out) throws XMLStreamException, JAXBException {
        Marshaller marshaller = PLUGIN_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement<PluginType> element = new ObjectFactory().createGeronimoPlugin(metadata);
        marshaller.marshal(element, out);
    }

    public static void writePluginArtifact(PluginArtifactType value, Writer out) throws XMLStreamException, JAXBException {
        Marshaller marshaller = PLUGIN_ARTIFACT_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement element = new JAXBElement(_PluginArtifact_QNAME, PluginArtifactType.class, null, (Object)value);
        marshaller.marshal((Object)element, out);
    }

    public static void writePluginList(PluginListType metadata, Writer out) throws XMLStreamException, JAXBException {
        Marshaller marshaller = PLUGIN_LIST_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBElement<PluginListType> element = new ObjectFactory().createGeronimoPluginList(metadata);
        marshaller.marshal(element, out);
    }

    public static PluginType loadPluginMetadata(InputStream in) throws SAXException, MalformedURLException, JAXBException, XMLStreamException {
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        Unmarshaller unmarshaller = PLUGIN_CONTEXT.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal(xmlStream, PluginType.class);
        PluginType plugin = (PluginType)element.getValue();
        return plugin;
    }

    public static PluginArtifactType loadPluginArtifactMetadata(Reader in) throws SAXException, MalformedURLException, JAXBException, XMLStreamException, ParserConfigurationException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        Unmarshaller unmarshaller = PLUGIN_ARTIFACT_CONTEXT.createUnmarshaller();
        NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, inputSource);
        JAXBElement element = unmarshaller.unmarshal((Source)source, PluginArtifactType.class);
        PluginArtifactType plugin = (PluginArtifactType)element.getValue();
        return plugin;
    }

    public static PluginListType loadPluginList(InputStream in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = PLUGIN_LIST_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, PluginListType.class);
        PluginListType pluginList = (PluginListType)element.getValue();
        return pluginList;
    }

    static {
        _PluginArtifact_QNAME = new QName("http://geronimo.apache.org/xml/ns/plugins-1.3", "plugin-artifact");
        try {
            PLUGIN_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{PluginType.class});
            PLUGIN_LIST_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{PluginListType.class});
            PLUGIN_ARTIFACT_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{PluginArtifactType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb contexts for plugin types");
        }
    }

    public static class NamespaceFilter
    extends XMLFilterImpl {
        private static String PLUGIN_NS = "http://geronimo.apache.org/xml/ns/plugins-1.3";
        private static String GBEAN_NS = "http://geronimo.apache.org/xml/ns/attributes-1.2";
        private static String ENVIRONMENT_NS = "http://geronimo.apache.org/xml/ns/deployment-1.2";
        private String namespace;

        public NamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            if ("plugin-artifact".equals(localName)) {
                this.namespace = PLUGIN_NS;
            } else if ("gbean".equals(localName)) {
                this.namespace = GBEAN_NS;
            } else if ("environment".equals(localName)) {
                this.namespace = ENVIRONMENT_NS;
            }
            super.startElement(this.namespace, localName, qname, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this.namespace, localName, qName);
            if ("plugin-artifact".equals(localName)) {
                this.namespace = null;
            } else if ("gbean".equals(localName)) {
                this.namespace = PLUGIN_NS;
            } else if ("environment".equals(localName)) {
                this.namespace = GBEAN_NS;
            }
        }
    }
}

