/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.Maven2Repository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.plugin.LocalOpenResult;
import org.apache.geronimo.system.plugin.OpenResult;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;

public class LocalSourceRepository
extends Maven2Repository
implements SourceRepository {
    private final ArtifactResolver artifactResolver = new DefaultArtifactResolver(new DefaultArtifactManager(), this);

    public LocalSourceRepository(File base) {
        super(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginListType getPluginList() {
        PluginListType pluginListType;
        FileInputStream in = new FileInputStream(new File(this.rootFile, "geronimo-plugins.xml"));
        try {
            pluginListType = PluginXmlUtil.loadPluginList(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        in.close();
        return pluginListType;
    }

    @Override
    public OpenResult open(Artifact artifact, FileWriteMonitor monitor) throws IOException, FailedLoginException {
        if (!artifact.isResolved()) {
            try {
                artifact = this.artifactResolver.resolveInClassLoader(artifact);
            }
            catch (MissingDependencyException e) {
                throw (IOException)new IOException("Could not resolve artifact " + artifact + " in repo " + this.rootFile).initCause(e);
            }
        }
        File location = this.getLocation(artifact);
        return new LocalOpenResult(artifact, location);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.rootFile;
    }
}

