/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.MultipleMatchesException;
import org.apache.geronimo.kernel.repository.Version;

@GBean(j2eeType="ArtifactResolver")
public class DefaultArtifactResolver
implements ArtifactResolver {
    private final ArtifactManager artifactManager;
    private final Collection<ListableRepository> repositories;
    private final Map<Artifact, Artifact> explicitResolution = new ConcurrentHashMap<Artifact, Artifact>();
    private final Collection<ConfigurationManager> configurationManagers;

    public DefaultArtifactResolver(ArtifactManager artifactManager, ListableRepository repository) {
        this.artifactManager = artifactManager;
        this.repositories = Collections.singleton(repository);
        this.configurationManagers = Collections.emptyList();
    }

    public DefaultArtifactResolver(@ParamReference(name="ArtifactManager", namingType="ArtifactManager") ArtifactManager artifactManager, @ParamReference(name="Repositories", namingType="Repository") Collection<ListableRepository> repositories, @ParamAttribute(name="explicitResolution") Map<Artifact, Artifact> explicitResolution, @ParamReference(name="ConfigurationManagers", namingType="ConfigurationManager") Collection<ConfigurationManager> configurationManagers) {
        this.artifactManager = artifactManager;
        this.repositories = repositories;
        if (explicitResolution != null) {
            this.explicitResolution.putAll(explicitResolution);
        }
        this.configurationManagers = configurationManagers;
    }

    protected Map<Artifact, Artifact> getExplicitResolution() {
        return this.explicitResolution;
    }

    @Override
    public Artifact generateArtifact(Artifact source, String defaultType) {
        if (source.isResolved()) {
            Artifact deAliased = this.explicitResolution.get(source);
            if (deAliased != null) {
                return deAliased;
            }
            return source;
        }
        String groupId = source.getGroupId() == null ? "default" : source.getGroupId();
        String artifactId = source.getArtifactId();
        String type = source.getType() == null ? defaultType : source.getType();
        Version version = source.getVersion() == null ? new Version(Long.toString(System.currentTimeMillis())) : source.getVersion();
        return new Artifact(groupId, artifactId, version, type);
    }

    @Override
    public Artifact queryArtifact(Artifact artifact) throws MultipleMatchesException {
        Artifact[] all = this.queryArtifacts(artifact);
        if (all.length > 1) {
            throw new MultipleMatchesException(artifact);
        }
        return all.length == 0 ? null : all[0];
    }

    @Override
    public Artifact[] queryArtifacts(Artifact artifact) {
        Artifact deAliased = this.explicitResolution.get(artifact);
        if (deAliased != null) {
            artifact = deAliased;
        }
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>();
        for (ListableRepository repository : this.repositories) {
            set.addAll(repository.list(artifact));
        }
        return set.toArray(new Artifact[set.size()]);
    }

    @Override
    public LinkedHashSet<Artifact> resolveInClassLoader(Collection<Artifact> artifacts) throws MissingDependencyException {
        return this.resolveInClassLoader(artifacts, Collections.<Configuration>emptySet());
    }

    @Override
    public LinkedHashSet<Artifact> resolveInClassLoader(Collection<Artifact> artifacts, Collection<Configuration> parentConfigurations) throws MissingDependencyException {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!artifact.isResolved()) {
                artifact = this.resolveInClassLoader(artifact, parentConfigurations);
            }
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    @Override
    public Artifact resolveInClassLoader(Artifact source) throws MissingDependencyException {
        return this.resolveInClassLoader(source, Collections.<Configuration>emptySet());
    }

    @Override
    public Artifact resolveInClassLoader(Artifact source, Collection<Configuration> parentConfigurations) throws MissingDependencyException {
        Artifact working = this.resolveVersion(parentConfigurations, source);
        if (working == null || !working.isResolved()) {
            throw new MissingDependencyException(source);
        }
        return working;
    }

    private Artifact resolveVersion(Collection<Configuration> parentConfigurations, Artifact working) {
        Artifact deAliased = this.explicitResolution.get(working);
        if (deAliased != null) {
            working = deAliased;
        }
        if (working.isResolved()) {
            return working;
        }
        SortedSet<Object> existingArtifacts = this.artifactManager != null ? this.artifactManager.getLoadedArtifacts(working) : new TreeSet();
        if (existingArtifacts.size() == 1) {
            return (Artifact)existingArtifacts.first();
        }
        if (existingArtifacts.size() == 0) {
            TreeSet<Artifact> list = new TreeSet<Artifact>();
            for (ListableRepository repository : this.repositories) {
                list.addAll(repository.list(working));
            }
            if (list.isEmpty()) {
                return null;
            }
            return (Artifact)list.last();
        }
        Artifact artifact = this.searchParents(parentConfigurations, working);
        if (artifact != null) {
            return artifact;
        }
        return (Artifact)existingArtifacts.last();
    }

    private Artifact searchParents(Collection<Configuration> parentConfigurations, Artifact working) {
        for (Configuration configuration : parentConfigurations) {
            Artifact artifact = this.searchParent(configuration, working);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    private Artifact searchParent(Configuration configuration, Artifact working) {
        if (this.matches(configuration.getId(), working)) {
            return configuration.getId();
        }
        Environment environment = configuration.getEnvironment();
        if (environment.getClassLoadingRules().isInverseClassLoading()) {
            Artifact artifact = this.getArtifactVersion(this.artifactManager.getLoadedArtifacts(configuration.getId()), working);
            if (artifact != null) {
                return artifact;
            }
            artifact = this.searchOneParent(configuration, working);
            if (artifact != null) {
                return artifact;
            }
        } else {
            Artifact artifact = this.searchOneParent(configuration, working);
            if (artifact != null) {
                return artifact;
            }
            artifact = this.getArtifactVersion(this.artifactManager.getLoadedArtifacts(configuration.getId()), working);
            if (artifact != null) {
                return artifact;
            }
        }
        return null;
    }

    private Artifact searchOneParent(Configuration configuration, Artifact working) {
        LinkedHashSet<Artifact> parentIds = configuration.getDependencyNode().getClassParents();
        if (!parentIds.isEmpty()) {
            for (Artifact parentId : parentIds) {
                Configuration parent = this.getConfiguration(parentId);
                Artifact artifact = this.searchParent(parent, working);
                if (artifact == null) continue;
                return artifact;
            }
        }
        return null;
    }

    private Configuration getConfiguration(Artifact parentId) {
        if (this.configurationManagers.size() != 1) {
            throw new IllegalStateException("no configuration manager");
        }
        return this.configurationManagers.iterator().next().getConfiguration(parentId);
    }

    private Artifact getArtifactVersion(Collection<Artifact> artifacts, Artifact query) {
        for (Artifact artifact : artifacts) {
            if (!this.matches(artifact, query)) continue;
            return artifact;
        }
        return null;
    }

    private boolean matches(Artifact candidate, Artifact query) {
        return query.matches(candidate);
    }
}

