/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.MultiGBeanInfoFactory;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.annotation.EncryptionSetting;
import org.osgi.framework.Bundle;

public class GBeanDataConverter
implements Converter {
    private final Mapper mapper;
    private final GBeanInfoFactory infoFactory;
    private final ThreadLocal<Bundle> currentBundle = new ThreadLocal();

    public GBeanDataConverter(Mapper mapper) {
        this.mapper = mapper;
        this.infoFactory = this.newGBeanInfoFactory();
    }

    public void setBundle(Bundle bundle) {
        this.currentBundle.set(bundle);
    }

    protected GBeanInfoFactory newGBeanInfoFactory() {
        return new MultiGBeanInfoFactory();
    }

    public boolean canConvert(Class clazz) {
        return GBeanData.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        GBeanInfo gbeanInfo;
        String sourceClass;
        GBeanData gbeanData = (GBeanData)object;
        AbstractName abstractName = gbeanData.getAbstractName();
        if (abstractName != null) {
            writer.addAttribute("name", abstractName.toString());
        }
        if ((sourceClass = (gbeanInfo = gbeanData.getGBeanInfo()).getSourceClass()) != null) {
            writer.addAttribute("sourceClass", sourceClass);
        } else {
            writer.startNode("gbean-info");
            marshallingContext.convertAnother((Object)gbeanInfo);
            writer.endNode();
        }
        Set<ReferencePatterns> dependencies = gbeanData.getDependencies();
        for (ReferencePatterns referencePatterns : dependencies) {
            writer.startNode("dependency");
            marshallingContext.convertAnother((Object)referencePatterns);
            writer.endNode();
        }
        Map<String, Object> attributes = gbeanData.getAttributes();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            EncryptionSetting encryptionSetting = gbeanInfo.getAttribute(attributeName).getEncryptedSetting();
            Object attributeValue = encryptionSetting.encrypt(entry.getValue());
            if (attributeValue == null) continue;
            writer.startNode("attribute");
            writer.addAttribute("name", attributeName);
            writer.startNode(this.mapper.serializedClass(attributeValue.getClass()));
            marshallingContext.convertAnother(attributeValue);
            writer.endNode();
            writer.endNode();
        }
        Map<String, ReferencePatterns> references = gbeanData.getReferences();
        for (Map.Entry<String, ReferencePatterns> entry : references.entrySet()) {
            String referenceName = entry.getKey();
            ReferencePatterns referencePatterns = entry.getValue();
            writer.startNode("reference");
            writer.addAttribute("name", referenceName);
            marshallingContext.convertAnother((Object)referencePatterns);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        Object attributeValue;
        String gbeanName = reader.getAttribute("name");
        AbstractName abstractName = null;
        if (gbeanName != null) {
            abstractName = new AbstractName(URI.create(gbeanName));
        }
        GBeanInfo gbeanInfo = null;
        String sourceClass = reader.getAttribute("sourceClass");
        if (sourceClass != null) {
            gbeanInfo = this.infoFactory.getGBeanInfo(sourceClass, this.currentBundle.get());
        }
        LinkedHashSet<ReferencePatterns> dependencies = new LinkedHashSet<ReferencePatterns>();
        LinkedHashMap attributes = new LinkedHashMap();
        LinkedHashMap<String, ReferencePatterns> references = new LinkedHashMap<String, ReferencePatterns>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals("gbean-info")) {
                if (gbeanInfo != null) {
                    throw new ConversionException("GBean info declared more than once in gbean " + abstractName);
                }
                gbeanInfo = (GBeanInfo)unmarshallingContext.convertAnother((Object)reader, GBeanInfo.class);
            } else if (nodeName.equals("dependency")) {
                ReferencePatterns referencePatterns = (ReferencePatterns)unmarshallingContext.convertAnother((Object)reader, ReferencePatterns.class);
                dependencies.add(referencePatterns);
            } else if (nodeName.equals("attribute")) {
                String attributeName = reader.getAttribute("name");
                reader.moveDown();
                String classAttribute = reader.getAttribute(this.mapper.attributeForImplementationClass());
                Class type = classAttribute == null ? this.mapper.realClass(reader.getNodeName()) : this.mapper.realClass(classAttribute);
                attributeValue = unmarshallingContext.convertAnother((Object)reader, type);
                reader.moveUp();
                attributes.put(attributeName, attributeValue);
            } else if (nodeName.equals("reference")) {
                String referenceName = reader.getAttribute("name");
                ReferencePatterns referencePatterns = (ReferencePatterns)unmarshallingContext.convertAnother((Object)reader, ReferencePatterns.class);
                references.put(referenceName, referencePatterns);
            } else {
                throw new ConversionException("Unknown nested node in GBean: " + nodeName);
            }
            reader.moveUp();
        }
        if (gbeanInfo == null) {
            throw new ConversionException("GBean info not declared in gbean " + abstractName);
        }
        GBeanData gbeanData = new GBeanData(abstractName, gbeanInfo);
        gbeanData.setDependencies(dependencies);
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            attributeValue = entry.getValue();
            gbeanData.setAttribute(attributeName, attributeValue);
        }
        for (Map.Entry entry : references.entrySet()) {
            String referenceName = (String)entry.getKey();
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            gbeanData.setReferencePatterns(referenceName, referencePatterns);
        }
        return gbeanData;
    }
}

