/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModel;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DependencyNode;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ConfigurationManager")
public class KernelConfigurationManager
extends SimpleConfigurationManager
implements GBeanLifecycle {
    protected final Kernel kernel;
    protected final ManageableAttributeStore attributeStore;
    protected final PersistentConfigurationList configurationList;
    private final ArtifactManager artifactManager;
    private final ShutdownHook shutdownHook;
    private boolean online = true;

    public KernelConfigurationManager(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamReference(name="Stores", namingType="ConfigurationStore") Collection<ConfigurationStore> stores, @ParamReference(name="AttributeStore", namingType="AttributeStore") ManageableAttributeStore attributeStore, @ParamReference(name="PersistentConfigurationList") PersistentConfigurationList configurationList, @ParamReference(name="ArtifactManager", namingType="ArtifactManager") ArtifactManager artifactManager, @ParamReference(name="ArtifactResolver", namingType="ArtifactResolver") ArtifactResolver artifactResolver, @ParamReference(name="Repositories", namingType="Repository") Collection<ListableRepository> repositories, @ParamReference(name="Watchers") Collection<DeploymentWatcher> watchers, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        super(stores, KernelConfigurationManager.createArtifactResolver(artifactResolver, artifactManager, repositories), repositories, watchers, bundleContext);
        this.kernel = kernel;
        this.attributeStore = attributeStore;
        this.configurationList = configurationList;
        this.artifactManager = artifactManager;
        this.shutdownHook = new ShutdownHook(kernel, this.configurationModel);
    }

    private static ArtifactResolver createArtifactResolver(ArtifactResolver artifactResolver, ArtifactManager artifactManager, Collection<ListableRepository> repositories) {
        if (artifactResolver != null) {
            return artifactResolver;
        }
        return new DefaultArtifactResolver(artifactManager, repositories, null, Collections.<ConfigurationManager>emptyList());
    }

    @Override
    public synchronized LifecycleResults loadConfiguration(Artifact configurationId) throws NoSuchConfigException, LifecycleException {
        AbstractName abstractName = null;
        try {
            abstractName = Configuration.getConfigurationAbstractName(configurationId);
        }
        catch (InvalidConfigException e) {
            throw new RuntimeException(e);
        }
        if (this.getConfiguration(configurationId) == null && this.kernel.isLoaded(abstractName)) {
            try {
                Configuration configuration = (Configuration)this.kernel.getGBean(abstractName);
                this.addNewConfigurationToModel(configuration);
                this.configurationModel.load(configurationId);
                this.configurationModel.start(configurationId);
                return new LifecycleResults();
            }
            catch (GBeanNotFoundException gBeanNotFoundException) {
                // empty catch block
            }
        }
        return super.loadConfiguration(configurationId);
    }

    @Override
    protected void load(Artifact configurationId) throws NoSuchConfigException {
        super.load(configurationId);
        if (this.configurationList != null) {
            this.configurationList.addConfiguration(configurationId);
        }
    }

    @Override
    protected void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration, boolean running) throws NoSuchConfigException {
        super.migrateConfiguration(oldName, newName, configuration, running);
        if (this.configurationList != null) {
            this.configurationList.migrateConfiguration(oldName, newName, configuration);
            if (running) {
                this.configurationList.startConfiguration(newName);
            }
        }
    }

    @Override
    protected Configuration load(ConfigurationData configurationData, LinkedHashSet<Artifact> resolvedParentIds, Map<Artifact, Configuration> loadedConfigurations) throws InvalidConfigException {
        Configuration configuration;
        Artifact configurationId = configurationData.getId();
        AbstractName configurationName = Configuration.getConfigurationAbstractName(configurationId);
        GBeanData gbeanData = new GBeanData(configurationName, Configuration.class);
        gbeanData.setAttribute("configurationData", configurationData);
        DependencyNode dependencyNode = null;
        ConfigurationResolver configurationResolver = new ConfigurationResolver(configurationData, this.repositories, this.getArtifactResolver());
        gbeanData.setAttribute("configurationResolver", configurationResolver);
        try {
            dependencyNode = this.buildDependencyNode(configurationData);
            gbeanData.setAttribute("dependencyNode", dependencyNode);
            gbeanData.setAttribute("allServiceParents", this.buildAllServiceParents(loadedConfigurations, dependencyNode));
        }
        catch (MissingDependencyException e) {
            throw new InvalidConfigException(e);
        }
        gbeanData.setAttribute("configurationManager", this);
        gbeanData.setAttribute("attributeStore", this.attributeStore);
        LinkedHashSet<AbstractName> parentNames = new LinkedHashSet<AbstractName>();
        for (Artifact resolvedParentId : resolvedParentIds) {
            if (!this.isConfiguration(resolvedParentId)) continue;
            AbstractName parentName = Configuration.getConfigurationAbstractName(resolvedParentId);
            parentNames.add(parentName);
        }
        gbeanData.addDependencies(parentNames);
        try {
            this.kernel.loadGBean(gbeanData, this.bundleContext);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Unable to load configuration gbean " + configurationId, e);
        }
        try {
            this.kernel.startGBean(configurationName);
            if (1 != this.kernel.getGBeanState(configurationName)) {
                String stateReason = this.kernel.getStateReason(configurationName);
                throw new InvalidConfigurationException("Configuration gbean failed to start " + configurationId + "\nreason: " + stateReason);
            }
            configuration = (Configuration)this.kernel.getGBean(configurationName);
            if (this.artifactManager != null) {
                this.artifactManager.loadArtifacts(configurationId, configuration.getDependencyNode().getParents());
            }
            LinkedHashMap<Artifact, Configuration> moreLoadedConfigurations = new LinkedHashMap<Artifact, Configuration>(loadedConfigurations);
            moreLoadedConfigurations.put(dependencyNode.getId(), configuration);
            for (Map.Entry<String, ConfigurationData> childEntry : configurationData.getChildConfigurations().entrySet()) {
                ConfigurationResolver childResolver = configurationResolver.createChildResolver(childEntry.getKey());
                Configuration child = this.doLoad(childEntry.getValue(), resolvedParentIds, moreLoadedConfigurations, childResolver);
                configuration.addChild(child);
            }
            log.debug("Loaded Configuration {}", (Object)configurationName);
        }
        catch (Exception e) {
            this.unload(configurationId);
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw new InvalidConfigException("Error starting configuration gbean " + configurationId, e);
        }
        return configuration;
    }

    @Override
    public void start(Configuration configuration) throws InvalidConfigException {
        if (this.online) {
            ConfigurationUtil.startConfigurationGBeans(configuration.getAbstractName(), configuration, this.kernel);
        }
        if (this.configurationList != null && configuration.getConfigurationData().isAutoStart()) {
            this.configurationList.startConfiguration(configuration.getId());
        }
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    protected void stop(Configuration configuration) {
        this.stopRecursive(configuration);
        if (this.configurationList != null) {
            this.configurationList.stopConfiguration(configuration.getId());
        }
    }

    private void stopRecursive(Configuration configuration) {
        AbstractName gbeanName;
        for (Configuration childConfiguration : configuration.getChildren()) {
            this.stopRecursive(childConfiguration);
        }
        Collection<GBeanData> gbeans = configuration.getGBeans().values();
        for (GBeanData gbeanData : gbeans) {
            gbeanName = gbeanData.getAbstractName();
            try {
                this.kernel.stopGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                log.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
            }
        }
        for (GBeanData gbeanData : gbeans) {
            gbeanName = gbeanData.getAbstractName();
            try {
                this.kernel.unloadGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                log.debug("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName, (Throwable)kernelException);
            }
        }
    }

    @Override
    protected void unload(Configuration configuration) {
        Artifact configurationId = configuration.getId();
        this.unload(configurationId);
    }

    private void unload(Artifact configurationId) {
        AbstractName configurationName;
        try {
            configurationName = Configuration.getConfigurationAbstractName(configurationId);
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
        if (this.artifactManager != null) {
            this.artifactManager.unloadAllArtifacts(configurationId);
        }
        try {
            this.kernel.stopGBean(configurationName);
        }
        catch (GBeanNotFoundException ignored) {
        }
        catch (Exception stopException) {
            log.warn("Unable to stop failed configuration: " + configurationId, (Throwable)stopException);
        }
        try {
            this.kernel.unloadGBean(configurationName);
        }
        catch (GBeanNotFoundException ignored) {
        }
        catch (Exception unloadException) {
            log.warn("Unable to unload failed configuration: " + configurationId, (Throwable)unloadException);
        }
    }

    @Override
    protected void uninstall(Artifact configurationId) {
        if (this.configurationList != null) {
            this.configurationList.removeConfiguration(configurationId);
        }
    }

    @Override
    public void doStart() {
        this.kernel.registerShutdownHook(this.shutdownHook);
    }

    @Override
    public void doStop() {
        this.kernel.unregisterShutdownHook(this.shutdownHook);
    }

    @Override
    public void doFail() {
        log.error("Cofiguration manager failed");
    }

    private static class ShutdownHook
    implements Runnable {
        private final Kernel kernel;
        private final ConfigurationModel configurationModel;
        private final Logger log = LoggerFactory.getLogger(ShutdownHook.class);

        public ShutdownHook(Kernel kernel, ConfigurationModel configurationModel) {
            this.kernel = kernel;
            this.configurationModel = configurationModel;
        }

        @Override
        public void run() {
            Set<AbstractName> configs;
            block5: while (!(configs = this.kernel.listGBeans(new AbstractNameQuery(Configuration.class.getName()))).isEmpty()) {
                LinkedHashSet<AbstractName> orderedConfigs = new LinkedHashSet<AbstractName>();
                for (AbstractName configName : configs) {
                    if (!this.kernel.isLoaded(configName) || orderedConfigs.contains(configName)) continue;
                    LinkedHashSet<Artifact> startedChildren = this.configurationModel.getStartedChildren(configName.getArtifact());
                    for (Artifact configurationId : startedChildren) {
                        AbstractName childConfigName;
                        Set<AbstractName> childConfig = this.kernel.listGBeans(new AbstractNameQuery(configurationId, Collections.emptyMap(), Configuration.class.getName()));
                        if (childConfig.isEmpty() || orderedConfigs.contains(childConfigName = childConfig.iterator().next())) continue;
                        orderedConfigs.add(childConfigName);
                    }
                    orderedConfigs.add(configName);
                }
                Iterator<AbstractName> i = orderedConfigs.iterator();
                while (true) {
                    AbstractName configName;
                    if (!i.hasNext()) continue block5;
                    configName = i.next();
                    try {
                        this.kernel.stopGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                    catch (InternalKernelException e) {
                        this.log.warn("Could not stop configuration: " + configName, (Throwable)e);
                    }
                    try {
                        this.kernel.unloadGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                }
                break;
            }
            return;
        }
    }
}

