/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class TemporaryClassLoader
extends URLClassLoader {
    public TemporaryClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public TemporaryClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public TemporaryClassLoader(URL[] urls) {
        super(urls);
    }

    public TemporaryClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String packageName;
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.")) {
            return this.getParent().loadClass(name);
        }
        String resourceName = name.replace('.', '/') + ".class";
        InputStream in = this.getResourceAsStream(resourceName);
        if (in == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
        byte[] bytes = new byte[]{};
        try {
            byte[] buf = new byte[4096];
            int count = -1;
            while ((count = in.read(buf)) >= 0) {
                bout.write(buf, 0, count);
            }
            bytes = bout.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (TemporaryClassLoader.isAnnotationClass(bytes)) {
            return super.loadClass(name, resolve);
        }
        int packageEndIndex = name.lastIndexOf(46);
        if (packageEndIndex != -1 && this.getPackage(packageName = name.substring(0, packageEndIndex)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        try {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (SecurityException e) {
            return super.loadClass(name, resolve);
        }
    }

    private static boolean isAnnotationClass(byte[] bytes) {
        IsAnnotationVisitor isAnnotationVisitor = new IsAnnotationVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isAnnotationVisitor, 2);
        return isAnnotationVisitor.isAnnotation;
    }

    public static class IsAnnotationVisitor
    extends EmptyVisitor {
        public boolean isAnnotation = false;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isAnnotation = (access & 0x2000) != 0;
        }
    }
}

