/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.GBeanReference;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.gbean.runtime.ReflectionMethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGBeanReference
implements GBeanReference {
    protected static final boolean NO_PROXY;
    private final String name;
    private final Class referenceType;
    private final Class proxyType;
    private final GBeanInstance gbeanInstance;
    private final MethodInvoker setInvoker;
    private final boolean hasTargets;
    private final GReferenceInfo referenceInfo;
    private final Kernel kernel;
    private Object proxy;

    public AbstractGBeanReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, boolean hasTargets) throws InvalidConfigurationException {
        this.gbeanInstance = gbeanInstance;
        this.referenceInfo = referenceInfo;
        this.kernel = kernel;
        this.hasTargets = hasTargets;
        this.name = referenceInfo.getName();
        try {
            this.referenceType = ClassLoading.loadClass(referenceInfo.getReferenceType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Reference Type: " + this.getDescription(), e);
        }
        if (Modifier.isFinal(this.referenceType.getModifiers())) {
            throw new IllegalArgumentException("Proxy interface cannot be a final class: " + this.referenceType.getName());
        }
        try {
            this.proxyType = ClassLoading.loadClass(referenceInfo.getProxyType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Proxy Type:" + this.getDescription(), e);
        }
        if (referenceInfo.getSetterName() != null) {
            try {
                String setterName = referenceInfo.getSetterName();
                Method setterMethod = gbeanInstance.getType().getMethod(setterName, this.proxyType);
                if (NO_PROXY) {
                    this.setInvoker = new ReflectionMethodInvoker(setterMethod);
                }
                this.setInvoker = new FastMethodInvoker(setterMethod);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidConfigurationException("Setter method not found " + this.getDescription(), e);
            }
        } else {
            this.setInvoker = null;
        }
    }

    protected final Kernel getKernel() {
        return this.kernel;
    }

    public final GBeanInstance getGBeanInstance() {
        return this.gbeanInstance;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final GReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    @Override
    public final Class getReferenceType() {
        return this.referenceType;
    }

    @Override
    public final Class getProxyType() {
        return this.proxyType;
    }

    @Override
    public final Object getProxy() {
        return this.proxy;
    }

    protected final void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    protected boolean isRunning(Kernel kernel, AbstractName abstractName) {
        try {
            int state = kernel.getGBeanState(abstractName);
            return state == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getDescription() {
        return "\n    GBeanInstance: " + this.gbeanInstance.getName() + "\n    Reference Name: " + this.getName() + "\n    Reference Type: " + this.referenceInfo.getReferenceType() + "\n    Proxy Type: " + this.referenceInfo.getProxyType();
    }

    static {
        Logger log = LoggerFactory.getLogger(AbstractGBeanReference.class);
        String no_proxy = System.getProperty("Xorg.apache.geronimo.gbean.NoProxy", "true");
        NO_PROXY = no_proxy.equalsIgnoreCase("true");
        if (NO_PROXY) {
            log.info("GBean references are not using proxies");
        } else {
            log.info("GBean references are using proxies");
        }
    }
}

