/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class ArrayPropertyEditorAdapter
extends PropertyEditorSupport {
    private Class type;
    private PropertyEditor editor;

    public ArrayPropertyEditorAdapter(Class type, PropertyEditor editor) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Editor is null");
        }
        this.type = type;
        this.editor = editor;
    }

    @Override
    public void setAsText(String text) {
        if (text == null || text.length() == 0) {
            this.setValue(null);
        } else {
            StringTokenizer stok = new StringTokenizer(text, ",");
            LinkedList<Object> list = new LinkedList<Object>();
            while (stok.hasMoreTokens()) {
                this.editor.setAsText(stok.nextToken());
                list.add(this.editor.getValue());
            }
            Object array = Array.newInstance(this.type, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            this.setValue(array);
        }
    }

    @Override
    public String getAsText() {
        Object[] objects = (Object[])this.getValue();
        if (objects == null || objects.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer(String.valueOf(objects[0]));
        for (int i = 1; i < objects.length; ++i) {
            result.append(",").append(objects[i]);
        }
        return result.toString();
    }
}

