/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common;

import org.apache.geronimo.common.DeploymentException;

public class UnresolvedEJBRefException
extends DeploymentException {
    private final String refName;
    private final boolean local;
    private final boolean session;
    private final String homeInterface;
    private final String beanInterface;

    public UnresolvedEJBRefException(String refName, boolean local, boolean session, String homeInterface, String beanInterface, boolean foundMultiple) {
        super(UnresolvedEJBRefException.createMessage(refName, local, session, homeInterface, beanInterface, foundMultiple));
        this.refName = refName;
        this.local = local;
        this.session = session;
        this.homeInterface = homeInterface;
        this.beanInterface = beanInterface;
    }

    public String getRefName() {
        return this.refName;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isSession() {
        return this.session;
    }

    public String getHomeInterface() {
        return this.homeInterface;
    }

    public String getBeanInterface() {
        return this.beanInterface;
    }

    private static String createMessage(String refName, boolean local, boolean session, String homeInterface, String beanInterface, boolean foundMultiple) {
        StringBuilder msg = new StringBuilder();
        if (foundMultiple) {
            msg.append("Two or more EJBs were found");
        } else {
            msg.append("Could not find an EJB");
        }
        msg.append(" for reference ").append(refName).append(" to a ");
        msg.append(local ? "local " : "remote ");
        msg.append(session ? "session" : "entity");
        msg.append(" bean that has the home interface ").append(homeInterface);
        msg.append(" and the ").append(local ? "local" : "remote");
        msg.append(" interface ").append(beanInterface);
        return msg.toString();
    }
}

