/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
@Vetoed
public class ClassConverter
implements Converter<Class> {
    public static final Converter<Class> INSTANCE = new ClassConverter();

    public Class convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return Class.forName(value);
            }
            return Class.forName(value, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

