/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;

public abstract class BaseConfigSource
implements ConfigSource {
    public static final String CONFIG_ORDINAL = "config_ordinal";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private int ordinal = 1000;

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void initOrdinal(int defaultOrdinal) {
        this.ordinal = defaultOrdinal;
        String configuredOrdinalString = this.getValue(CONFIG_ORDINAL);
        try {
            if (configuredOrdinalString != null) {
                this.ordinal = Integer.parseInt(configuredOrdinalString.trim());
            }
        }
        catch (NumberFormatException e) {
            this.log.log(Level.WARNING, "The configured config-ordinal isn't a valid integer. Invalid value: " + configuredOrdinalString);
        }
    }
}

