/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.IndexInfo;
import org.apache.geode.management.runtime.RuntimeRegionInfo;
import org.apache.geode.security.ResourcePermission;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="regionManagement")
@RequestMapping(value={"/v1"})
public class RegionManagementController
extends AbstractManagementController {
    @Operation(summary="create region")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Region already exists."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @PostMapping(value={"/regions"})
    public ResponseEntity<ClusterManagementResult> createRegion(@RequestBody Region regionConfig) {
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)regionConfig);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="list regions", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result[] | .groups[] | .runtimeInfo[] + .configuration | {name:.name,type:.type,entryCount:.entryCount}")})})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/regions"})
    public ClusterManagementListResult<Region, RuntimeRegionInfo> listRegion(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        Region filter = new Region();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filter.setName(id);
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }

    @Operation(summary="get region", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result | .groups[] | .runtimeInfo[] + .configuration | {name:.name,type:.type,entryCount:.entryCount}")})})
    @GetMapping(value={"/regions/{id:.+}"})
    public ClusterManagementGetResult<Region, RuntimeRegionInfo> getRegion(@PathVariable(name="id") String id) {
        this.securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, id);
        Region config = new Region();
        config.setName(id);
        return this.clusterManagementService.get((AbstractConfiguration)config);
    }

    @Operation(summary="delete region")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @DeleteMapping(value={"/regions/{id:.+}"})
    public ClusterManagementResult deleteRegion(@PathVariable(name="id") String id, @RequestParam(required=false) String group) {
        Region config = new Region();
        config.setName(id);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            config.setGroup(group);
        }
        return this.clusterManagementService.delete((AbstractConfiguration)config);
    }

    @Operation(summary="list region indexes", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result[] | .groups[] | .configuration | {name:.name,expression:.expression}")})})
    @GetMapping(value={"/regions/{regionName}/indexes"})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ', 'QUERY')")
    public ClusterManagementListResult<Index, IndexInfo> listIndex(@PathVariable String regionName, @RequestParam(required=false, name="id") String indexName) {
        Index filter = new Index();
        filter.setRegionPath(regionName);
        if (StringUtils.isNotBlank((CharSequence)indexName)) {
            filter.setName(indexName);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }

    @Operation(summary="list indexes", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result[] | .groups[] | .configuration | {name:.name,expression:.expression,regionPath:.regionPath}")})})
    @GetMapping(value={"/indexes"})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ', 'QUERY')")
    public ClusterManagementListResult<Index, IndexInfo> listAllIndex(@RequestParam(required=false, name="id") String indexName) {
        Index filter = new Index();
        if (StringUtils.isNotBlank((CharSequence)indexName)) {
            filter.setName(indexName);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }

    @Operation(summary="get index", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result | .groups[] | .configuration | {name:.name,expression:.expression}")})})
    @GetMapping(value={"/regions/{regionName}/indexes/{id:.+}"})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ', 'QUERY')")
    public ClusterManagementGetResult<Index, IndexInfo> getIndex(@PathVariable String regionName, @PathVariable String id) {
        Index filter = new Index();
        filter.setRegionPath(regionName);
        filter.setName(id);
        return this.clusterManagementService.get((AbstractConfiguration)filter);
    }

    @Operation(summary="create index")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Index already exists."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE', 'QUERY')")
    @PostMapping(value={"/indexes"})
    public ResponseEntity<ClusterManagementResult> createIndex(@RequestBody Index indexConfig) {
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)indexConfig);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="create region index")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Index already exists."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE', 'QUERY')")
    @PostMapping(value={"/regions/{regionName}/indexes"})
    public ResponseEntity<ClusterManagementResult> createIndexOnRegion(@RequestBody Index indexConfig, @PathVariable String regionName) {
        if (indexConfig.getRegionName() == null) {
            indexConfig.setRegionPath(regionName);
        } else if (!regionName.equals(indexConfig.getRegionName())) {
            throw new IllegalArgumentException("Region name in path must match Region name in configuration");
        }
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)indexConfig);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="delete region index")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE', 'QUERY')")
    @DeleteMapping(value={"/regions/{regionName}/indexes/{indexName:.+}"})
    public ClusterManagementResult deleteIndex(@PathVariable String regionName, @PathVariable String indexName) {
        Index config = new Index();
        config.setName(indexName);
        config.setRegionPath(regionName);
        return this.clusterManagementService.delete((AbstractConfiguration)config);
    }
}

