/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.DeploymentInfo;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="deploymentManagement")
@RequestMapping(value={"/v1"})
public class DeploymentManagementController
extends AbstractManagementController {
    @Autowired
    private Jackson2ObjectMapperFactoryBean objectMapper;
    private static final Logger logger = LogService.getLogger();

    @Operation(summary="list deployed")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/deployments"})
    public ClusterManagementListResult<Deployment, DeploymentInfo> list(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        Deployment deployment = new Deployment();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            deployment.setFileName(id);
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            deployment.setGroup(group);
        }
        return this.clusterManagementService.list((AbstractConfiguration)deployment);
    }

    @Operation(summary="get deployed")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/deployments/{id:.+}"})
    public ClusterManagementGetResult<Deployment, DeploymentInfo> getDeployed(@PathVariable(name="id") String id) {
        Deployment deployment = new Deployment();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            deployment.setFileName(id);
        }
        return this.clusterManagementService.get((AbstractConfiguration)deployment);
    }

    @Operation(summary="deploy")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE', 'DEPLOY')")
    @PutMapping(value={"/deployments"}, consumes={"multipart/form-data"})
    public ResponseEntity<ClusterManagementResult> deploy(@Parameter(name="filePath", required=true) @RequestParam(value="file") MultipartFile file, @Parameter(description="deployment json configuration") @RequestParam(value="config", required=false) String json) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("No file uploaded");
        }
        Path tempDir = FileUploader.createSecuredTempDirectory((String)"uploaded-");
        File targetFile = new File(tempDir.toFile(), file.getOriginalFilename());
        file.transferTo(targetFile);
        Deployment deployment = new Deployment();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            deployment = (Deployment)this.objectMapper.getObject().readValue(json, Deployment.class);
        }
        deployment.setFile(targetFile);
        ClusterManagementRealizationResult realizationResult = this.clusterManagementService.create((AbstractConfiguration)deployment);
        return new ResponseEntity((Object)realizationResult, HttpStatus.CREATED);
    }
}

