/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.rest.internal.web.controllers.AbstractBaseController;
import org.apache.geode.rest.internal.web.exception.GemfireRestException;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.geode.rest.internal.web.util.JSONUtils;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="functionController")
@Api(value="functions", description="Rest api for gemfire function execution", tags={"functions"})
@RequestMapping(value={"/v1/functions"})
public class FunctionAccessController
extends AbstractBaseController {
    static final String REST_API_VERSION = "/v1";
    private static final Logger logger = LogService.getLogger();

    @Override
    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="list all functions", notes="list all functions available in the GemFire cluster")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="@securityService.authorize('DATA', 'READ')")
    public ResponseEntity<?> list() {
        logger.debug("Listing all registered Functions in GemFire...");
        Map registeredFunctions = FunctionService.getRegisteredFunctions();
        String listFunctionsAsJson = JSONUtils.formulateJsonForListFunctionsCall(registeredFunctions.keySet());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri("functions"));
        return new ResponseEntity((Object)listFunctionsAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{functionId:.+}"}, produces={"application/json"})
    @ApiOperation(value="execute function", notes="Execute function with arguments on regions, members, or group(s). By default function will be executed on all nodes if none of (onRegion, onMembers, onGroups) specified")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="if GemFire throws an error or exception"), @ApiResponse(code=400, message="if Function arguments specified as JSON document in the request body is invalid")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> execute(@PathVariable(value="functionId") String functionId, @RequestParam(value="onRegion", required=false) String region, @RequestParam(value="onMembers", required=false) String[] members, @RequestParam(value="onGroups", required=false) String[] groups, @RequestParam(value="filter", required=false) String[] filter, @RequestBody(required=false) String argsInBody) {
        ResultCollector results;
        Function function = FunctionService.getFunction((String)functionId);
        if (function == null) {
            throw new EntityNotFoundException(String.format("The function %s is not registered.", functionId));
        }
        Object[] args = null;
        if (argsInBody != null) {
            args = this.jsonToObjectArray(argsInBody);
        }
        Collection requiredPermissions = function.getRequiredPermissions(region, (Object)args);
        for (ResourcePermission requiredPermission : requiredPermissions) {
            this.securityService.authorize(requiredPermission);
        }
        Execution execution = null;
        functionId = this.decode(functionId);
        if (StringUtils.hasText((String)region)) {
            logger.debug("Executing Function ({}) with arguments ({}) on Region ({})...", (Object)functionId, (Object)ArrayUtils.toString(argsInBody), (Object)region);
            region = this.decode(region);
            try {
                execution = FunctionService.onRegion(this.getRegion(region));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException(String.format("The Region identified by name (%1$s) could not found!", region), fe);
            }
        }
        if (ArrayUtils.isNotEmpty(members)) {
            logger.debug("Executing Function ({}) with arguments ({}) on Member ({})...", (Object)functionId, (Object)ArrayUtils.toString(argsInBody), (Object)ArrayUtils.toString(members));
            try {
                execution = FunctionService.onMembers(this.getMembers(members));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("Could not found the specified members in distributed system!", fe);
            }
        }
        if (ArrayUtils.isNotEmpty(groups)) {
            logger.debug("Executing Function ({}) with arguments ({}) on Groups ({})...", (Object)functionId, (Object)ArrayUtils.toString(argsInBody), (Object)ArrayUtils.toString(groups));
            try {
                execution = FunctionService.onMembers((String[])groups);
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("no member(s) are found belonging to the provided group(s)!", fe);
            }
        }
        logger.debug("Executing Function ({}) with arguments ({}) on all Members...", (Object)functionId, (Object)ArrayUtils.toString(argsInBody));
        try {
            execution = FunctionService.onMembers(this.getAllMembersInDS());
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Distributed system does not contain any valid data node to run the specified  function!", fe);
        }
        if (!ArrayUtils.isEmpty(filter)) {
            logger.debug("Executing Function ({}) with filter ({})", (Object)functionId, (Object)ArrayUtils.toString(filter));
            Set filter1 = ArrayUtils.asSet(filter);
            execution = execution.withFilter(filter1);
        }
        try {
            results = args != null ? (args.length == 1 ? execution.setArguments(args[0]).execute(functionId) : execution.setArguments((Object)args).execute(functionId)) : execution.execute(functionId);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Key is of an inappropriate type for this region!", cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("Specified key is null and this region does not permit null keys!", npe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has encountered low memory condition!", lme);
        }
        catch (IllegalArgumentException ie) {
            throw new GemfireRestException("Input parameter is null! ", ie);
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Server has encountered error while executing the function!", fe);
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(this.toUri("functions", functionId));
            Object functionResult = null;
            if (results instanceof NoResult) {
                return new ResponseEntity((Object)"", (MultiValueMap)headers, HttpStatus.OK);
            }
            functionResult = results.getResult();
            if (functionResult instanceof List) {
                try {
                    String functionResultAsJson = JSONUtils.convertCollectionToJson((ArrayList)functionResult);
                    return new ResponseEntity((Object)functionResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
                }
                catch (JSONException e) {
                    throw new GemfireRestException("Could not convert function results into Restful (JSON) format!", e);
                }
            }
            throw new GemfireRestException("Function has returned results that could not be converted into Restful (JSON) format!");
        }
        catch (FunctionException fe) {
            fe.printStackTrace();
            throw new GemfireRestException("Server has encountered an error while processing function execution!", fe);
        }
    }
}

