/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.execute.util.FindRestEnabledServersFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.rest.internal.web.controllers.AbstractBaseController;
import org.apache.geode.rest.internal.web.controllers.support.RestServersResultCollector;
import org.apache.geode.rest.internal.web.exception.GemfireRestException;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.geode.rest.internal.web.util.JSONUtils;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class CommonCrudController
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="list all resources (Regions)", notes="List all available resources (Regions) in the Geode cluster")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'READ')")
    public ResponseEntity<?> regions() {
        logger.debug("Listing all resources (Regions) in Geode...");
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[0]));
        Set regions = this.getCache().rootRegions();
        String listRegionsAsJson = JSONUtils.formulateJsonForListRegions(regions, "regions");
        return new ResponseEntity((Object)listRegionsAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{region}/keys"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="list all keys", notes="List all keys in region")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist"), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'READ', #region)")
    public ResponseEntity<?> keys(@PathVariable(value="region") String region) {
        logger.debug("Reading all Keys in Region ({})...", (Object)region);
        region = this.decode(region);
        Object[] keys = this.getKeys(region, null);
        String listKeysAsJson = JSONUtils.formulateJsonForListKeys(keys, "keys");
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(region, "keys"));
        return new ResponseEntity((Object)listKeysAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{region}/{keys}"}, produces={"application/json"})
    @ApiOperation(value="delete data for key(s)", notes="Delete data for single key or specific keys in region")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region or key(s) does not exist"), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    @PreAuthorize(value="@securityService.authorize('WRITE', #region, #keys)")
    public ResponseEntity<?> delete(@PathVariable(value="region") String region, @PathVariable(value="keys") String[] keys) {
        logger.debug("Delete data for key {} on region {}", (Object)ArrayUtils.toString((Object[])keys), (Object)region);
        region = this.decode(region);
        this.deleteValues(region, keys);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{region}"})
    @ApiOperation(value="delete all data", notes="Delete all data in the region")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist"), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'WRITE', #region)")
    public ResponseEntity<?> delete(@PathVariable(value="region") String region) {
        logger.debug("Deleting all data in Region ({})...", (Object)region);
        region = this.decode(region);
        this.deleteValues(region);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"/ping"})
    @ApiOperation(value="Check Rest service status ", notes="Check whether gemfire REST service is up and running!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    public ResponseEntity<?> ping() {
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/servers"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="fetch all REST enabled servers in the DS", notes="Find all gemfire node where developer REST service is up and running!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    public ResponseEntity<?> servers() {
        Execution function;
        logger.debug("Executing function to get REST enabled gemfire nodes in the DS!");
        try {
            function = FunctionService.onMembers(this.getAllMembersInDS());
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Distributed system does not contain any valid data node that can host REST service!", fe);
        }
        try {
            ResultCollector results = function.withCollector(new RestServersResultCollector()).execute(FindRestEnabledServersFunction.FIND_REST_ENABLED_SERVERS_FUNCTION_ID);
            Object functionResult = results.getResult();
            if (functionResult instanceof List) {
                HttpHeaders headers = new HttpHeaders();
                headers.setLocation(this.toUri("servers"));
                try {
                    String functionResultAsJson = JSONUtils.convertCollectionToJson((ArrayList)functionResult);
                    return new ResponseEntity((Object)functionResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
                }
                catch (JSONException e) {
                    throw new GemfireRestException("Could not convert function results into Restful (JSON) format!", e);
                }
            }
            throw new GemfireRestException("Function has returned results that could not be converted into Restful (JSON) format!");
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Key is of an inappropriate type for this region!", cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("Specified key is null and this region does not permit null keys!", npe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has encountered low memory condition!", lme);
        }
        catch (IllegalArgumentException ie) {
            throw new GemfireRestException("Input parameter is null! ", ie);
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Server has encountered error while executing the function!", fe);
        }
    }
}

