/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.WanCopyRegionFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

public class WanCopyRegionCommand
extends GfshCommand {
    private final WanCopyRegionFunction wanCopyRegionFunction = new WanCopyRegionFunction();
    public static final String WAN_COPY_REGION = "wan-copy region";
    public static final String WAN_COPY_REGION__HELP = "Copy a region with a senderId via WAN replication";
    public static final String WAN_COPY_REGION__REGION = "region";
    public static final String WAN_COPY_REGION__REGION__HELP = "Region from which data will be exported.";
    public static final String WAN_COPY_REGION__SENDERID = "sender-id";
    public static final String WAN_COPY_REGION__SENDERID__HELP = "Sender Id to use to copy the region.";
    public static final String WAN_COPY_REGION__MAXRATE = "max-rate";
    public static final String WAN_COPY_REGION__MAXRATE__HELP = "Maximum rate for copying in entries per second.";
    public static final String WAN_COPY_REGION__BATCHSIZE = "batch-size";
    public static final String WAN_COPY_REGION__BATCHSIZE__HELP = "Number of entries to be copied in each batch.";
    public static final String WAN_COPY_REGION__CANCEL = "cancel";
    public static final String WAN_COPY_REGION__CANCEL__HELP = "Cancel an ongoing wan-copy region command";

    @ShellMethodAvailability(value={"wan-copy region"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }

    @ShellMethod(value="Copy a region with a senderId via WAN replication", key={"wan-copy region"})
    @CliMetaData(relatedTopic={"Data", "Region"})
    public ResultModel wanCopyRegion(@ShellOption(value={"region"}, defaultValue="__NULL__", help="Region from which data will be exported.") String regionName, @ShellOption(value={"sender-id"}, defaultValue="__NULL__", help="Sender Id to use to copy the region.") String senderId, @ShellOption(value={"max-rate"}, defaultValue="0", help="Maximum rate for copying in entries per second.") long maxRate, @ShellOption(value={"batch-size"}, defaultValue="1000", help="Number of entries to be copied in each batch.") int batchSize, @ShellOption(value={"cancel"}, defaultValue="false", arity=0, help="Cancel an ongoing wan-copy region command") boolean isCancel) {
        if (regionName == null || senderId == null) {
            return ResultModel.createError((String)"Both --region and --sender-id are required");
        }
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        Object[] args = new Object[]{regionName, senderId, isCancel, maxRate, batchSize};
        ResultCollector resultCollector = this.executeFunction((Function)this.wanCopyRegionFunction, args, this.getAllNormalMembers());
        List<CliFunctionResult> cliFunctionResults = this.getCliFunctionResults((List)resultCollector.getResult());
        return ResultModel.createMemberStatusResult(cliFunctionResults, (boolean)false, (boolean)false);
    }

    private List<CliFunctionResult> getCliFunctionResults(List<CliFunctionResult> resultsObjects) {
        ArrayList<CliFunctionResult> cliFunctionResults = new ArrayList<CliFunctionResult>();
        for (CliFunctionResult result : resultsObjects) {
            if (result instanceof FunctionInvocationTargetException) {
                CliFunctionResult errorResult = new CliFunctionResult(((FunctionInvocationTargetException)result).getMemberId().getName(), CliFunctionResult.StatusState.ERROR, ((FunctionInvocationTargetException)result).getMessage());
                cliFunctionResults.add(errorResult);
                continue;
            }
            cliFunctionResults.add(result);
        }
        return cliFunctionResults;
    }
}

