/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AdvancedSocketCreatorImpl
implements AdvancedSocketCreator {
    public static final boolean ENABLE_TCP_KEEP_ALIVE;
    private static Logger logger;
    protected final TcpSocketCreatorImpl socketCreator;

    protected AdvancedSocketCreatorImpl(TcpSocketCreatorImpl socketCreator) {
        this.socketCreator = socketCreator;
    }

    @Override
    public boolean useSSL() {
        return this.socketCreator.useSSL();
    }

    @Override
    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (this.useSSL()) {
            throw new IllegalStateException("Handshake on SSL connections is not supported");
        }
    }

    @Override
    public Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, boolean allowClientSocketFactory, int socketBufferSize, boolean useSSL) throws IOException {
        return this.connect(addr, timeout, optionalWatcher, allowClientSocketFactory, socketBufferSize, useSSL, Socket::new);
    }

    @Override
    public Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, boolean allowClientSocketFactory, int socketBufferSize, boolean useSSL, TcpSocketFactory socketFactory) throws IOException {
        if (useSSL) {
            throw new IllegalArgumentException();
        }
        Socket socket = null;
        if (allowClientSocketFactory) {
            socket = this.createCustomClientSocket(addr);
        }
        if (socket == null) {
            socket = socketFactory.createSocket();
            socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
            if (socketBufferSize != -1) {
                socket.setReceiveBufferSize(socketBufferSize);
            }
            if (optionalWatcher != null) {
                optionalWatcher.beforeConnect(socket);
            }
            InetSocketAddress inetSocketAddress = addr.getSocketInetAddress();
            try {
                socket.connect(inetSocketAddress, Math.max(timeout, 0));
            }
            catch (ConnectException connectException) {
                logger.info("Failed to connect to " + inetSocketAddress);
                throw connectException;
            }
            finally {
                if (optionalWatcher != null) {
                    optionalWatcher.afterConnect(socket);
                }
            }
        }
        return socket;
    }

    @Override
    public final ServerSocket createServerSocketUsingPortRange(InetAddress ba, int backlog, boolean isBindAddress, boolean useNIO, int tcpBufferSize, int[] tcpPortRange, boolean sslConnection) throws IOException {
        try {
            int startingPort;
            int localPort = startingPort = tcpPortRange[0] + ThreadLocalRandom.current().nextInt(tcpPortRange[1] - tcpPortRange[0] + 1);
            int portLimit = tcpPortRange[1];
            while (true) {
                if (localPort > portLimit) {
                    if (startingPort != 0) {
                        localPort = tcpPortRange[0];
                        portLimit = startingPort - 1;
                        startingPort = 0;
                    } else {
                        throw this.noFreePortException(String.format("Unable to find a free port in the membership-port-range: [%d,%d]", tcpPortRange[0], tcpPortRange[1]));
                    }
                }
                ServerSocket socket = null;
                try {
                    if (useNIO) {
                        ServerSocketChannel channel = ServerSocketChannel.open();
                        socket = channel.socket();
                        InetSocketAddress address = new InetSocketAddress(isBindAddress ? ba : null, localPort);
                        socket.bind(address, backlog);
                    } else {
                        socket = this.socketCreator.clusterSocketCreator.createServerSocket(localPort, backlog, isBindAddress ? ba : null, tcpBufferSize, sslConnection);
                    }
                    return socket;
                }
                catch (SocketException ex) {
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                    ++localPort;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw this.problemCreatingSocketInPortRangeException("unable to create a socket in the membership-port range", e);
        }
    }

    protected RuntimeException problemCreatingSocketInPortRangeException(String s, IOException e) {
        return new RuntimeException(s, e);
    }

    protected RuntimeException noFreePortException(String reason) {
        return new RuntimeException(reason);
    }

    protected Socket createCustomClientSocket(HostAndPort addr) throws IOException {
        throw new UnsupportedOperationException("custom client socket factory is not supported by this socket creator");
    }

    static {
        logger = LogService.getLogger();
        String str = System.getProperty("gemfire.setTcpKeepAlive");
        ENABLE_TCP_KEEP_ALIVE = str != null ? Boolean.valueOf(str) : true;
    }
}

