/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.geode.internal.serialization.filter.SanctionedSerializablesService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SanctionedSerializables {
    private static final Logger logger = LogService.getLogger();

    public static Set<SanctionedSerializablesService> loadSanctionedSerializablesServices() {
        ServiceLoader<SanctionedSerializablesService> loader = ServiceLoader.load(SanctionedSerializablesService.class);
        HashSet<SanctionedSerializablesService> services = new HashSet<SanctionedSerializablesService>();
        for (SanctionedSerializablesService service : loader) {
            services.add(service);
        }
        return services;
    }

    static Collection<String> loadClassNames(URL sanctionedSerializables) throws IOException {
        if (sanctionedSerializables == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(1000);
        try (InputStream inputStream = sanctionedSerializables.openStream();
             BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                line = line.replaceAll("/", ".");
                result.add(line.substring(0, line.indexOf(44)));
            }
        }
        return result;
    }

    public static Set<String> loadSanctionedClassNames(Iterable<SanctionedSerializablesService> services) {
        HashSet<String> sanctionedClasses = new HashSet<String>(650);
        for (SanctionedSerializablesService service : services) {
            try {
                Collection<String> classNames = service.getSerializationAcceptlist();
                logger.info("loaded {} sanctioned serializables from {}", (Object)classNames.size(), (Object)service.getClass().getSimpleName());
                sanctionedClasses.addAll(classNames);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to initialize serialization filter for " + String.valueOf(service), e);
            }
        }
        return sanctionedClasses;
    }

    private SanctionedSerializables() {
    }
}

