/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.lang.ref.SoftReference;

public class ThreadLocalByteArrayCache {
    private final ThreadLocal<SoftReference<byte[]>> cache = new ThreadLocal();
    private final int maximumArraySize;

    public ThreadLocalByteArrayCache(int maximumArraySize) {
        this.maximumArraySize = maximumArraySize;
    }

    public byte[] get(int minimumLength) {
        byte[] result;
        SoftReference<byte[]> reference = this.cache.get();
        byte[] byArray = result = reference != null ? reference.get() : null;
        if (result == null || result.length < minimumLength) {
            result = new byte[minimumLength];
            if (minimumLength <= this.maximumArraySize) {
                this.cache.set(new SoftReference<byte[]>(result));
            }
        }
        return result;
    }
}

