/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.apache.geode.tools.pulse.internal.util.TimeUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberClients")
@Scope(value="singleton")
public class MemberClientsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String NAME = "name";
    private final String HOST = "host";

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberClients").get("memberName").textValue();
        ArrayNode clientListJson = this.mapper.createArrayNode();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName(memberName));
        if (clusterMember != null) {
            Cluster.Client[] memberClients;
            responseJSON.put("memberId", clusterMember.getId());
            responseJSON.put(this.NAME, clusterMember.getName());
            responseJSON.put(this.HOST, clusterMember.getHost());
            for (Cluster.Client memberClient : memberClients = clusterMember.getMemberClients()) {
                ObjectNode regionJSON = this.mapper.createObjectNode();
                regionJSON.put("clientId", memberClient.getId());
                regionJSON.put(this.NAME, memberClient.getName());
                regionJSON.put(this.HOST, memberClient.getHost());
                regionJSON.put("queueSize", memberClient.getQueueSize());
                regionJSON.put("clientCQCount", memberClient.getClientCQCount());
                regionJSON.put("isConnected", memberClient.isConnected() ? "Yes" : "No");
                regionJSON.put("isSubscriptionEnabled", memberClient.isSubscriptionEnabled() ? "Yes" : "No");
                regionJSON.put("uptime", TimeUtils.convertTimeSecondsToHMS(memberClient.getUptime()));
                regionJSON.put("cpuUsage", String.format("%.4f", memberClient.getCpuUsage()));
                regionJSON.put("threads", memberClient.getThreads());
                regionJSON.put("gets", memberClient.getGets());
                regionJSON.put("puts", memberClient.getPuts());
                clientListJson.add((JsonNode)regionJSON);
            }
            responseJSON.put("memberClients", (JsonNode)clientListJson);
        }
        return responseJSON;
    }
}

