/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterRegions")
@Scope(value="singleton")
public class ClusterRegionsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String ENTRY_SIZE = "entrySize";
    private static Comparator<Cluster.Region> regionEntryCountComparator = (r1, r2) -> {
        long r2Cnt;
        long r1Cnt = r1.getSystemRegionEntryCount();
        if (r1Cnt < (r2Cnt = r2.getSystemRegionEntryCount())) {
            return -1;
        }
        if (r1Cnt > r2Cnt) {
            return 1;
        }
        return 0;
    };

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put("regions", (JsonNode)this.getRegionJson(cluster));
        return responseJSON;
    }

    private ArrayNode getRegionJson(Cluster cluster) {
        Long totalHeapSize = cluster.getTotalHeapSize();
        Long totalDiskUsage = cluster.getTotalBytesOnDisk();
        Map<String, Cluster.Region> clusterRegions = cluster.getClusterRegions();
        ArrayList<Cluster.Region> clusterRegionsList = new ArrayList<Cluster.Region>();
        clusterRegionsList.addAll(clusterRegions.values());
        Collections.sort(clusterRegionsList, regionEntryCountComparator);
        ArrayNode regionListJson = this.mapper.createArrayNode();
        for (int count = 0; count < clusterRegionsList.size(); ++count) {
            Cluster.Region reg = (Cluster.Region)clusterRegionsList.get(count);
            ObjectNode regionJSON = this.mapper.createObjectNode();
            regionJSON.put("name", reg.getName());
            regionJSON.put("totalMemory", totalHeapSize);
            regionJSON.put("systemRegionEntryCount", reg.getSystemRegionEntryCount());
            regionJSON.put("memberCount", reg.getMemberCount());
            String regionType = reg.getRegionType();
            regionJSON.put("type", regionType);
            regionJSON.put("getsRate", reg.getGetsRate());
            regionJSON.put("putsRate", reg.getPutsRate());
            Cluster.Member[] clusterMembersList = cluster.getMembers();
            ArrayNode memberNameArray = this.mapper.createArrayNode();
            block1: for (String memberName : reg.getMemberName()) {
                for (Cluster.Member member : clusterMembersList) {
                    String name = member.getName();
                    name = name.replace(":", "-");
                    String id = member.getId();
                    if (!memberName.equals(id = id.replace(":", "-")) && !memberName.equals(name)) continue;
                    ObjectNode regionMember = this.mapper.createObjectNode();
                    regionMember.put("id", member.getId());
                    regionMember.put("name", member.getName());
                    memberNameArray.add((JsonNode)regionMember);
                    continue block1;
                }
            }
            regionJSON.put("memberNames", (JsonNode)memberNameArray);
            regionJSON.put("entryCount", reg.getSystemRegionEntryCount());
            Boolean persistent = reg.getPersistentEnabled();
            if (persistent.booleanValue()) {
                regionJSON.put("persistence", "ON");
            } else {
                regionJSON.put("persistence", "OFF");
            }
            Boolean isEnableOffHeapMemory = reg.isEnableOffHeapMemory();
            if (isEnableOffHeapMemory.booleanValue()) {
                regionJSON.put("isEnableOffHeapMemory", "ON");
            } else {
                regionJSON.put("isEnableOffHeapMemory", "OFF");
            }
            String regCompCodec = reg.getCompressionCodec();
            if (StringUtils.isNotBlank((String)regCompCodec)) {
                regionJSON.put("compressionCodec", reg.getCompressionCodec());
            } else {
                regionJSON.put("compressionCodec", "NA");
            }
            regionJSON.put("regionPath", reg.getFullPath());
            regionJSON.put("id", reg.getFullPath());
            regionJSON.put("memoryReadsTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(0)));
            regionJSON.put("memoryWritesTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(1)));
            regionJSON.put("diskReadsTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(3)));
            regionJSON.put("diskWritesTrend", this.mapper.valueToTree((Object)reg.getRegionStatisticTrend(4)));
            regionJSON.put("emptyNodes", reg.getEmptyNode());
            Long entrySize = reg.getEntrySize();
            String entrySizeInMB = PulseConstants.FOUR_PLACE_DECIMAL_FORMAT.format((float)entrySize.longValue() / 1048576.0f);
            if (entrySize < 0L) {
                regionJSON.put(this.ENTRY_SIZE, "NA");
            } else {
                regionJSON.put(this.ENTRY_SIZE, entrySizeInMB);
            }
            regionJSON.put("dataUsage", reg.getDiskUsage());
            regionJSON.put("wanEnabled", reg.getWanEnabled());
            regionJSON.put("totalDataUsage", totalDiskUsage);
            regionJSON.put("memoryUsage", entrySizeInMB);
            regionListJson.add((JsonNode)regionJSON);
        }
        return regionListJson;
    }
}

