/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseVersion;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.service.PulseServiceFactory;
import org.apache.geode.tools.pulse.internal.service.SystemAlertsService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PulseController {
    private static final Logger logger = LogManager.getLogger();
    private final String DEFAULT_EXPORT_FILENAME = "DataBrowserQueryResult.json";
    private final String QUERYSTRING_PARAM_ACTION = "action";
    private final String QUERYSTRING_PARAM_QUERYID = "queryId";
    private final String ACTION_VIEW = "view";
    private final String ACTION_DELETE = "delete";
    private String STATUS_REPSONSE_SUCCESS = "success";
    private String STATUS_REPSONSE_FAIL = "fail";
    private String ERROR_REPSONSE_QUERYNOTFOUND = "No queries found";
    private String ERROR_REPSONSE_QUERYIDMISSING = "Query id is missing";
    private static final String EMPTY_JSON = "{}";
    public static PulseVersion pulseVersion = new PulseVersion();
    private static String pulseProductSupport = "gemfire";
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    PulseServiceFactory pulseServiceFactory;

    @RequestMapping(value={"/pulseUpdate"}, method={RequestMethod.POST})
    public void getPulseUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pulseData = request.getParameter("pulseData");
        ObjectNode responseMap = this.mapper.createObjectNode();
        JsonNode requestMap = null;
        try {
            requestMap = this.mapper.readTree(pulseData);
            Iterator keys = requestMap.fieldNames();
            while (keys.hasNext()) {
                String serviceName = keys.next().toString();
                try {
                    PulseService pulseService = this.pulseServiceFactory.getPulseServiceInstance(serviceName);
                    responseMap.put(serviceName, (JsonNode)pulseService.execute(request));
                }
                catch (Exception serviceException) {
                    logger.warn("serviceException [for service {}] = {}", (Object)serviceName, (Object)serviceException.getMessage());
                    responseMap.put(serviceName, EMPTY_JSON);
                }
            }
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
        response.getOutputStream().write(responseMap.toString().getBytes());
    }

    @RequestMapping(value={"/authenticateUser"}, method={RequestMethod.GET})
    public void authenticateUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode responseJSON = this.mapper.createObjectNode();
        try {
            responseJSON.put("isUserLoggedIn", this.isUserLoggedIn(request));
            response.getOutputStream().write(responseJSON.toString().getBytes());
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
    }

    protected boolean isUserLoggedIn(HttpServletRequest request) {
        return null != request.getUserPrincipal();
    }

    @RequestMapping(value={"/pulseVersion"}, method={RequestMethod.GET})
    public void pulseVersion(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode responseJSON = this.mapper.createObjectNode();
        try {
            responseJSON.put("pulseVersion", pulseVersion.getPulseVersion());
            responseJSON.put("buildId", pulseVersion.getPulseBuildId());
            responseJSON.put("buildDate", pulseVersion.getPulseBuildDate());
            responseJSON.put("sourceDate", pulseVersion.getPulseSourceDate());
            responseJSON.put("sourceRevision", pulseVersion.getPulseSourceRevision());
            responseJSON.put("sourceRepository", pulseVersion.getPulseSourceRepository());
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
        response.getOutputStream().write(responseJSON.toString().getBytes());
    }

    @RequestMapping(value={"/clearAlerts"}, method={RequestMethod.GET})
    public void clearAlerts(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int alertType;
        ObjectNode responseJSON = this.mapper.createObjectNode();
        try {
            alertType = Integer.valueOf(request.getParameter("alertType"));
        }
        catch (NumberFormatException e) {
            response.getOutputStream().write(responseJSON.toString().getBytes());
            logger.debug((Object)e);
            return;
        }
        try {
            boolean isClearAll = Boolean.valueOf(request.getParameter("clearAll"));
            Cluster cluster = Repository.get().getCluster();
            cluster.clearAlerts(alertType, isClearAll);
            responseJSON.put("status", "deleted");
            responseJSON.put("systemAlerts", (JsonNode)SystemAlertsService.getAlertsJson(cluster, cluster.getNotificationPageNumber()));
            responseJSON.put("pageNumber", cluster.getNotificationPageNumber());
            boolean isGFConnected = cluster.isConnectedFlag();
            if (isGFConnected) {
                responseJSON.put("connectedFlag", isGFConnected);
            } else {
                responseJSON.put("connectedFlag", isGFConnected);
                responseJSON.put("connectedErrorMsg", cluster.getConnectionErrorMsg());
            }
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
        response.getOutputStream().write(responseJSON.toString().getBytes());
    }

    @RequestMapping(value={"/acknowledgeAlert"}, method={RequestMethod.GET})
    public void acknowledgeAlert(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int alertId;
        ObjectNode responseJSON = this.mapper.createObjectNode();
        try {
            alertId = Integer.valueOf(request.getParameter("alertId"));
        }
        catch (NumberFormatException e) {
            response.getOutputStream().write(responseJSON.toString().getBytes());
            logger.debug((Object)e);
            return;
        }
        try {
            Cluster cluster = Repository.get().getCluster();
            cluster.acknowledgeAlert(alertId);
            responseJSON.put("status", "deleted");
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : {}", (Throwable)e);
        }
        response.getOutputStream().write(responseJSON.toString().getBytes());
    }

    @RequestMapping(value={"/dataBrowserRegions"}, method={RequestMethod.GET})
    public void dataBrowserRegions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        ArrayNode regionsData = this.mapper.createArrayNode();
        try {
            responseJSON.put("clusterName", cluster.getServerName());
            regionsData = this.getRegionsJson(cluster);
            responseJSON.put("clusterRegions", (JsonNode)regionsData);
            responseJSON.put("connectedFlag", cluster.isConnectedFlag());
            responseJSON.put("connectedErrorMsg", cluster.getConnectionErrorMsg());
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : {}", (Throwable)e);
        }
        response.getOutputStream().write(responseJSON.toString().getBytes());
    }

    private ArrayNode getRegionsJson(Cluster cluster) {
        Collection<Cluster.Region> clusterRegions = cluster.getClusterRegions().values();
        ArrayNode regionsListJson = this.mapper.createArrayNode();
        if (!clusterRegions.isEmpty()) {
            for (Cluster.Region region : clusterRegions) {
                ObjectNode regionJSON = this.mapper.createObjectNode();
                regionJSON.put("name", region.getName());
                regionJSON.put("fullPath", region.getFullPath());
                regionJSON.put("regionType", region.getRegionType());
                if (region.getRegionType().contains("PARTITION")) {
                    regionJSON.put("isPartition", true);
                } else {
                    regionJSON.put("isPartition", false);
                }
                regionJSON.put("memberCount", region.getMemberCount());
                List<String> regionsMembers = region.getMemberName();
                ArrayNode jsonRegionMembers = this.mapper.createArrayNode();
                for (int i = 0; i < regionsMembers.size(); ++i) {
                    Cluster.Member member = cluster.getMembersHMap().get(regionsMembers.get(i));
                    ObjectNode jsonMember = this.mapper.createObjectNode();
                    jsonMember.put("key", regionsMembers.get(i));
                    jsonMember.put("id", member.getId());
                    jsonMember.put("name", member.getName());
                    jsonRegionMembers.add((JsonNode)jsonMember);
                }
                regionJSON.put("members", (JsonNode)jsonRegionMembers);
                regionsListJson.add((JsonNode)regionJSON);
            }
        }
        return regionsListJson;
    }

    @RequestMapping(value={"/dataBrowserQuery"}, method={RequestMethod.GET})
    public void dataBrowserQuery(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query = request.getParameter("query");
        String members = request.getParameter("members");
        int limit = 0;
        try {
            limit = Integer.valueOf(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            limit = 0;
            logger.debug((Object)e);
        }
        ObjectNode queryResult = this.executeQuery(request, query, members, limit);
        response.getOutputStream().write(queryResult.toString().getBytes());
    }

    @RequestMapping(value={"/dataBrowserQueryHistory"}, method={RequestMethod.GET})
    public void dataBrowserQueryHistory(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode responseJSON = this.mapper.createObjectNode();
        ArrayNode queryResult = null;
        String action = "";
        try {
            Cluster cluster = Repository.get().getCluster();
            String userName = request.getUserPrincipal().getName();
            action = request.getParameter("action");
            if (StringUtils.isBlank((String)action)) {
                action = "view";
            }
            if (action.toLowerCase().equalsIgnoreCase("delete")) {
                String queryId = request.getParameter("queryId");
                if (StringUtils.isNotBlank((String)queryId)) {
                    boolean deleteStatus = cluster.deleteQueryById(userName, queryId);
                    if (deleteStatus) {
                        responseJSON.put("status", this.STATUS_REPSONSE_SUCCESS);
                    } else {
                        responseJSON.put("status", this.STATUS_REPSONSE_FAIL);
                        responseJSON.put("error", this.ERROR_REPSONSE_QUERYNOTFOUND);
                    }
                } else {
                    responseJSON.put("status", this.STATUS_REPSONSE_FAIL);
                    responseJSON.put("error", this.ERROR_REPSONSE_QUERYIDMISSING);
                }
            }
            queryResult = cluster.getQueryHistoryByUserId(userName);
            responseJSON.put("queryHistory", (JsonNode)queryResult);
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
        response.getOutputStream().write(responseJSON.toString().getBytes());
    }

    @RequestMapping(value={"/dataBrowserExport"}, method={RequestMethod.GET})
    public void dataBrowserExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query = request.getParameter("query");
        String members = request.getParameter("members");
        int limit = 0;
        try {
            limit = Integer.valueOf(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            limit = 0;
            logger.debug((Object)e);
        }
        ObjectNode queryResult = this.executeQuery(request, query, members, limit);
        response.setContentType("application/json");
        response.setHeader("Content-Disposition", "attachment; filename=results.json");
        response.getOutputStream().write(queryResult.toString().getBytes());
    }

    @RequestMapping(value={"/getQueryStatisticsGridModel"}, method={RequestMethod.GET})
    public void getQueryStatisticsGridModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode responseJSON = this.mapper.createObjectNode();
        Cluster cluster = Repository.get().getCluster();
        String userName = request.getUserPrincipal().getName();
        try {
            String[] arrColNames = Cluster.Statement.getGridColumnNames();
            String[] arrColAttribs = Cluster.Statement.getGridColumnAttributes();
            int[] arrColWidths = Cluster.Statement.getGridColumnWidths();
            ArrayNode colNamesList = this.mapper.createArrayNode();
            for (int i = 0; i < arrColNames.length; ++i) {
                colNamesList.add(arrColNames[i]);
            }
            ArrayNode colModelList = this.mapper.createArrayNode();
            for (int i = 0; i < arrColAttribs.length; ++i) {
                ObjectNode columnJSON = this.mapper.createObjectNode();
                columnJSON.put("name", arrColAttribs[i]);
                columnJSON.put("index", arrColAttribs[i]);
                columnJSON.put("width", arrColWidths[i]);
                columnJSON.put("sortable", "true");
                columnJSON.put("sorttype", i == 0 ? "String" : "integer");
                colModelList.add((JsonNode)columnJSON);
            }
            responseJSON.put("columnNames", (JsonNode)colNamesList);
            responseJSON.put("columnModels", (JsonNode)colModelList);
            responseJSON.put("clusterName", cluster.getServerName());
            responseJSON.put("userName", userName);
            response.getOutputStream().write(responseJSON.toString().getBytes());
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
    }

    private ObjectNode executeQuery(HttpServletRequest request, String query, String members, int limit) {
        ObjectNode queryResult = this.mapper.createObjectNode();
        try {
            if (StringUtils.isNotBlank((String)query)) {
                Cluster cluster = Repository.get().getCluster();
                String userName = request.getUserPrincipal().getName();
                String escapedQuery = StringEscapeUtils.escapeHtml((String)query);
                cluster.addQueryInHistory(escapedQuery, userName);
                queryResult = cluster.executeQuery(query, members, limit);
            }
        }
        catch (Exception e) {
            logger.debug("Exception Occurred : ", (Throwable)e);
        }
        return queryResult;
    }
}

