/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.geode.tools.pulse.internal.controllers.PulseController;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PulseAppListener
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger();
    private static final String GEODE_SSLCONFIG_SERVLET_CONTEXT_PARAM = "org.apache.geode.sslConfig";
    private final boolean isEmbedded;
    private final Repository repository;
    private final ResourceBundle resourceBundle;
    private final BiFunction<String, ResourceBundle, Properties> propertiesFileLoader;

    public PulseAppListener() {
        this(Boolean.getBoolean("pulse.embedded"), Repository.get(), PulseAppListener::loadPropertiesFromFile);
    }

    public PulseAppListener(boolean isEmbedded, Repository repository, BiFunction<String, ResourceBundle, Properties> propertiesFileLoader) {
        this.isEmbedded = isEmbedded;
        this.repository = repository;
        this.resourceBundle = repository.getResourceBundle();
        this.propertiesFileLoader = propertiesFileLoader;
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.repository.removeAllClusters();
        logger.info("{}{}", (Object)this.resourceBundle.getString("LOG_MSG_CONTEXT_DESTROYED"), (Object)event.getServletContext().getContextPath());
    }

    public void contextInitialized(ServletContextEvent event) {
        logger.info(this.resourceBundle.getString("LOG_MSG_CONTEXT_INITIALIZED"));
        this.loadPulseVersionDetails();
        logger.info(this.resourceBundle.getString("LOG_MSG_CHECK_APP_RUNNING_MODE"));
        if (this.isEmbedded) {
            logger.info(this.resourceBundle.getString("LOG_MSG_APP_RUNNING_EMBEDDED_MODE"));
            this.repository.setJmxUseLocator(false);
            this.repository.setHost(System.getProperty("pulse.host", "localhost"));
            this.repository.setPort(System.getProperty("pulse.port", "1099"));
            this.repository.setUseSSLManager(Boolean.valueOf(System.getProperty("pulse.useSSL.manager")));
            this.repository.setUseSSLLocator(Boolean.valueOf(System.getProperty("pulse.useSSL.locator")));
            Object sslProperties = event.getServletContext().getAttribute(GEODE_SSLCONFIG_SERVLET_CONTEXT_PARAM);
            if (sslProperties instanceof Properties) {
                this.repository.setJavaSslProperties((Properties)sslProperties);
            }
        } else {
            logger.info(this.resourceBundle.getString("LOG_MSG_APP_RUNNING_NONEMBEDDED_MODE"));
            Properties pulseProperties = this.propertiesFileLoader.apply("pulse.properties", this.resourceBundle);
            this.repository.setJmxUseLocator(Boolean.valueOf(pulseProperties.getProperty("pulse.useLocator")));
            this.repository.setHost(pulseProperties.getProperty("pulse.host", "localhost"));
            this.repository.setPort(pulseProperties.getProperty("pulse.port", "1099"));
            this.repository.setUseSSLManager(Boolean.valueOf(pulseProperties.getProperty("pulse.useSSL.manager", "false")));
            this.repository.setUseSSLLocator(Boolean.valueOf(pulseProperties.getProperty("pulse.useSSL.locator", "false")));
            Properties pulseSecurityProperties = this.propertiesFileLoader.apply("pulsesecurity.properties", this.resourceBundle);
            if (!pulseSecurityProperties.isEmpty()) {
                Set<Map.Entry<Object, Object>> entrySet = pulseSecurityProperties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("javax.net.ssl.")) continue;
                    String val = (String)entry.getValue();
                    System.setProperty(key, val);
                }
                this.repository.setJavaSslProperties(pulseSecurityProperties);
            }
        }
    }

    private void loadPulseVersionDetails() {
        Properties properties = this.propertiesFileLoader.apply("GemFireVersion.properties", this.resourceBundle);
        PulseController.pulseVersion.setPulseVersion(properties.getProperty("Product-Version", ""));
        PulseController.pulseVersion.setPulseBuildId(properties.getProperty("Build-Id", ""));
        PulseController.pulseVersion.setPulseBuildDate(properties.getProperty("Build-Date", ""));
        PulseController.pulseVersion.setPulseSourceDate(properties.getProperty("Source-Date", ""));
        PulseController.pulseVersion.setPulseSourceRevision(properties.getProperty("Source-Revision", ""));
        PulseController.pulseVersion.setPulseSourceRepository(properties.getProperty("Source-Repository", ""));
        logger.info(PulseController.pulseVersion.getPulseVersionLogMessage());
    }

    private static Properties loadPropertiesFromFile(String propertyFile, ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFile);){
            logger.info(propertyFile + " " + resourceBundle.getString("LOG_MSG_FILE_FOUND"));
            properties.load(stream);
        }
        catch (IOException e) {
            logger.error(resourceBundle.getString("LOG_MSG_EXCEPTION_LOADING_PROPERTIES_FILE"), (Throwable)e);
        }
        return properties;
    }
}

