/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire;

import com.gemstone.gemfire.cache.execute.EmtpyRegionFunctionException;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.ClientReAuthenticateMessage;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataOutputStream;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.security.AuthenticationExpiredException;
import org.apache.geode.security.AuthenticationRequiredException;

public class OldClientSupportProvider
implements OldClientSupportService {
    static final String GEODE = "org.apache.geode";
    static final String GEMFIRE = "com.gemstone.gemfire";
    static final String ALWAYS_CONVERT_CLASSES_NAME = "gemfire.old-client-support.convert-all";
    static final boolean ALWAYS_CONVERT_CLASSES = Boolean.getBoolean("gemfire.old-client-support.convert-all");
    private final Map<String, String> oldClassNamesToNew = new ConcurrentHashMap<String, String>();
    private final Map<String, String> newClassNamesToOld = new ConcurrentHashMap<String, String>();

    public static OldClientSupportService getService(Cache cache) {
        return (OldClientSupportService)((InternalCache)cache).getService(OldClientSupportService.class);
    }

    public boolean init(Cache cache) {
        InternalDataSerializer.setOldClientSupportService((OldClientSupportService)this);
        return true;
    }

    public Class<? extends CacheService> getInterface() {
        return OldClientSupportService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public String processIncomingClassName(String name) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(oldPackage)) {
            Object cached = this.oldClassNamesToNew.get(name);
            if (cached == null) {
                cached = newPackage + name.substring(oldPackage.length());
                this.oldClassNamesToNew.put(name, (String)cached);
            }
            return cached;
        }
        return this.processClassName(name, GEMFIRE, GEODE, this.oldClassNamesToNew);
    }

    public String processIncomingClassName(String name, DataInput in) {
        return this.processIncomingClassName(name);
    }

    public String processOutgoingClassName(String name, DataOutput out) {
        VersionedDataOutputStream vout;
        KnownVersion version;
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(newPackage)) {
            return oldPackage + name.substring(newPackage.length());
        }
        if (ALWAYS_CONVERT_CLASSES) {
            return this.processClassName(name, GEODE, GEMFIRE, this.newClassNamesToOld);
        }
        if (out instanceof VersionedDataOutputStream && (version = (vout = (VersionedDataOutputStream)out).getVersion()) != null && version.isOlderThan((Version)KnownVersion.GFE_90)) {
            return this.processClassName(name, GEODE, GEMFIRE, this.newClassNamesToOld);
        }
        return name;
    }

    public Throwable getThrowable(Throwable theThrowable, KnownVersion clientVersion) {
        if (theThrowable == null) {
            return theThrowable;
        }
        if (clientVersion.isOlderThan((Version)ClientReAuthenticateMessage.RE_AUTHENTICATION_START_VERSION)) {
            if (theThrowable instanceof AuthenticationExpiredException) {
                return new AuthenticationRequiredException("User authorization attributes not found.");
            }
            Throwable cause = theThrowable.getCause();
            if (cause instanceof AuthenticationExpiredException) {
                return new AuthenticationRequiredException("User authorization attributes not found.");
            }
        }
        if (clientVersion.isNotOlderThan((Version)KnownVersion.GFE_90)) {
            return theThrowable;
        }
        String className = theThrowable.getClass().getName();
        if (className.equals("org.apache.geode.cache.execute.EmptyRegionFunctionException")) {
            return new EmtpyRegionFunctionException(theThrowable.getMessage(), theThrowable.getCause());
        }
        return theThrowable;
    }

    private String processClassName(String p_className, String oldPackage, String newPackage, Map<String, String> cache) {
        String cached = cache.get(p_className);
        if (cached != null) {
            return cached;
        }
        Object className = p_className;
        if (((String)className).startsWith(oldPackage)) {
            className = newPackage + ((String)className).substring(oldPackage.length());
        } else if (((String)className).startsWith("[") && ((String)className).contains("[L" + oldPackage)) {
            int idx = ((String)className).indexOf("[L") + 2;
            className = ((String)className).substring(0, idx) + newPackage + ((String)className).substring(idx, oldPackage.length());
        }
        if (className != p_className) {
            cache.put(p_className, (String)className);
        }
        return className;
    }
}

