/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader loader;

    public ClassLoaderObjectInputStream(InputStream in, ClassLoader loader, ObjectInputFilter filter) throws IOException {
        super(in);
        this.loader = loader;
        if (filter != null) {
            this.setObjectInputFilter(filter);
        }
    }

    @Deprecated
    public ClassLoaderObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        Class<?> theClass;
        try {
            theClass = Class.forName(desc.getName(), false, this.loader);
        }
        catch (ClassNotFoundException cnfe) {
            theClass = Thread.currentThread().getContextClassLoader().loadClass(desc.getName());
        }
        return theClass;
    }
}

