/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import jakarta.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.modules.session.catalina.AbstractSessionCache;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.callback.SessionExpirationCacheListener;
import org.apache.geode.modules.util.BootstrappingFunction;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionStatus;
import org.apache.geode.modules.util.SessionCustomExpiry;

public class ClientServerSessionCache
extends AbstractSessionCache {
    private final ClientCache cache;
    protected static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.PARTITION_REDUNDANT.toString();
    protected static final boolean DEFAULT_ENABLE_LOCAL_CACHE = true;

    public ClientServerSessionCache(SessionManager sessionManager, ClientCache cache) {
        super(sessionManager);
        this.cache = cache;
    }

    @Override
    public void initialize() {
        this.bootstrapServers();
        try {
            this.createOrRetrieveRegion();
        }
        catch (Exception ex) {
            this.sessionManager.getLogger().fatal((Object)"Unable to create or retrieve region", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        this.operatingRegion = this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public String getDefaultRegionAttributesId() {
        return DEFAULT_REGION_ATTRIBUTES_ID;
    }

    @Override
    public boolean getDefaultEnableLocalCache() {
        return true;
    }

    @Override
    public void touchSessions(Set<String> sessionIds) {
        String regionAttributesID = this.getSessionManager().getRegionAttributesId().toLowerCase();
        if (regionAttributesID.startsWith("partition")) {
            Execution execution = this.getExecutionForFunctionOnRegionWithFilter(sessionIds);
            try {
                ResultCollector collector = execution.execute("touch-partitioned-region-entries");
                collector.getResult();
            }
            catch (Exception e) {
                this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
            }
        } else {
            Object[] arguments = new Object[]{this.sessionRegion.getFullPath(), sessionIds};
            Execution execution = this.getExecutionForFunctionOnServersWithArguments(arguments);
            try {
                ResultCollector collector = execution.execute("touch-replicated-region-entries");
                collector.getResult();
            }
            catch (Exception e) {
                this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isPeerToPeer() {
        return false;
    }

    @Override
    public boolean isClientServer() {
        return true;
    }

    @Override
    public Set<String> keySet() {
        return this.getSessionRegion().keySetOnServer();
    }

    @Override
    public int size() {
        return this.getSessionRegion().sizeOnServer();
    }

    @Override
    public boolean isBackingCacheAvailable() {
        if (this.getSessionManager().isCommitValveFailfastEnabled()) {
            PoolImpl pool = this.findPoolInPoolManager();
            return pool.isPrimaryUpdaterAlive();
        }
        return true;
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    private void bootstrapServers() {
        Execution execution = this.getExecutionForFunctionOnServers();
        ResultCollector collector = execution.execute((Function)new BootstrappingFunction());
        try {
            collector.getResult();
        }
        catch (Exception e) {
            this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
        }
    }

    protected void createOrRetrieveRegion() {
        this.sessionRegion = this.cache.getRegion(this.getSessionManager().getRegionName());
        if (this.sessionRegion == null) {
            this.createSessionRegionOnServers();
            this.sessionRegion = this.createLocalSessionRegionWithRegisterInterest();
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created session region: " + String.valueOf(this.sessionRegion)));
            }
        } else {
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Retrieved session region: " + String.valueOf(this.sessionRegion)));
            }
            if (!this.regionHasExpirationListenerAttached(this.sessionRegion)) {
                this.sessionRegion.getAttributesMutator().addCacheListener((CacheListener)new SessionExpirationCacheListener());
            }
            if (this.sessionRegion.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
                this.sessionRegion.registerInterestForAllKeys(InterestResultPolicy.KEYS);
            }
        }
    }

    private boolean regionHasExpirationListenerAttached(Region<?, ?> region) {
        return Arrays.stream(region.getAttributes().getCacheListeners()).anyMatch(x -> x instanceof SessionExpirationCacheListener);
    }

    void createSessionRegionOnServers() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        Execution execution = this.getExecutionForFunctionOnServerWithRegionConfiguration(configuration);
        ResultCollector collector = execution.execute("create-region-function");
        List results = (List)collector.getResult();
        for (RegionStatus status : results) {
            if (status != RegionStatus.INVALID) continue;
            String builder = "An exception occurred on the server while attempting to create or validate region named " + this.getSessionManager().getRegionName() + ". See the server log for additional details.";
            throw new IllegalStateException(builder);
        }
    }

    Region<String, HttpSession> createLocalSessionRegionWithRegisterInterest() {
        Region<String, HttpSession> region = this.createLocalSessionRegion();
        if (region.getAttributes().getDataPolicy() != DataPolicy.EMPTY) {
            region.registerInterestForAllKeys(InterestResultPolicy.KEYS);
        }
        return region;
    }

    Region<String, HttpSession> createLocalSessionRegion() {
        ClientRegionFactory factory = null;
        if (this.getSessionManager().getEnableLocalCache()) {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY_HEAP_LRU);
            int maxInactiveInterval = this.getSessionManager().getMaxInactiveInterval();
            if (maxInactiveInterval != -1) {
                factory.setStatisticsEnabled(true);
                factory.setCustomEntryIdleTimeout((CustomExpiry)new SessionCustomExpiry());
                factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
            }
        } else {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
            factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
        }
        return factory.create(this.getSessionManager().getRegionName());
    }

    Execution getExecutionForFunctionOnServers() {
        return this.getExecutionForFunctionOnServersWithArguments(null);
    }

    Execution getExecutionForFunctionOnServersWithArguments(Object[] arguments) {
        if (arguments != null && arguments.length > 0) {
            return FunctionService.onServers((RegionService)this.getCache()).setArguments((Object)arguments);
        }
        return FunctionService.onServers((RegionService)this.getCache());
    }

    Execution getExecutionForFunctionOnServerWithRegionConfiguration(RegionConfiguration arguments) {
        if (arguments != null) {
            return FunctionService.onServer((RegionService)this.getCache()).setArguments((Object)arguments);
        }
        return FunctionService.onServer((RegionService)this.getCache());
    }

    Execution getExecutionForFunctionOnRegionWithFilter(Set<?> filter) {
        if (filter != null && filter.size() > 0) {
            return FunctionService.onRegion(this.getSessionRegion()).withFilter(filter);
        }
        return FunctionService.onRegion(this.getSessionRegion());
    }

    PoolImpl findPoolInPoolManager() {
        return (PoolImpl)PoolManager.find((String)this.getOperatingRegionName());
    }
}

