/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.bootstrap;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.modules.session.bootstrap.AbstractCache;
import org.apache.geode.modules.util.RegionHelper;

public class PeerToPeerCache
extends AbstractCache {
    private static final String DEFAULT_CACHE_XML_FILE_NAME = "cache-peer.xml";

    private PeerToPeerCache() {
    }

    public static AbstractCache getInstance() {
        return instance;
    }

    @Override
    protected void createOrRetrieveCache() {
        String message;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating cache");
        }
        try {
            this.cache = CacheFactory.getAnyInstance();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        if (this.cache == null || this.cache.isClosed()) {
            this.cache = new CacheFactory(this.createDistributedSystemProperties()).create();
            message = "Created ";
        } else {
            message = "Retrieved ";
        }
        this.getLogger().info(message + String.valueOf(this.cache));
    }

    @Override
    protected void rebalanceCache() {
        try {
            this.getLogger().info("Rebalancing: " + String.valueOf(this.cache));
            RebalanceResults results = RegionHelper.rebalanceCache(this.cache);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Done rebalancing: " + String.valueOf(this.cache));
                this.getLogger().debug(RegionHelper.getRebalanceResultsMessage(results));
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Rebalance failed because of the following exception:", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultCacheXmlFileName() {
        return DEFAULT_CACHE_XML_FILE_NAME;
    }

    static {
        instance = new PeerToPeerCache();
    }
}

