/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.bootstrap;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.distributed.internal.AbstractDistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.modules.session.bootstrap.LifecycleTypeAdapter;
import org.apache.geode.modules.util.Banner;
import org.apache.geode.modules.util.ResourceManagerValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache {
    protected GemFireCache cache;
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DEFAULT_LOG_FILE_NAME = "gemfire_modules." + FORMAT.format(new Date()) + ".log";
    private static final String DEFAULT_STATISTIC_ARCHIVE_FILE_NAME = "gemfire_modules.gfs";
    private static final float DEFAULT_EVICTION_HEAP_PERCENTAGE = 80.0f;
    private static final float DEFAULT_CRITICAL_HEAP_PERCENTAGE = 0.0f;
    private static final String GEMFIRE_PREFIX = "gemfire.";
    private static final String DEFAULT_CACHE_XML_FILE = DistributionConfig.DEFAULT_CACHE_XML_FILE.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCache.class);
    private float evictionHeapPercentage = 80.0f;
    private float criticalHeapPercentage = 0.0f;
    private boolean rebalance = false;
    private final Map<String, String> gemfireProperties;
    private final AtomicBoolean started = new AtomicBoolean(false);
    protected static AbstractCache instance = null;

    AbstractCache() {
        this.gemfireProperties = new ConcurrentHashMap<String, String>();
    }

    public void lifecycleEvent(LifecycleTypeAdapter eventType) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Received " + String.valueOf((Object)eventType) + " event");
        }
        if (eventType.equals((Object)LifecycleTypeAdapter.START) && this.started.compareAndSet(false, true)) {
            this.getLogger().info("Initializing " + Banner.getString());
            this.createOrRetrieveCache();
            this.initializeResourceManager();
        } else if (eventType.equals((Object)LifecycleTypeAdapter.AFTER_START)) {
            if (this.getRebalance()) {
                this.rebalanceCache();
            }
        } else if (eventType.equals((Object)LifecycleTypeAdapter.STOP)) {
            this.started.set(false);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void close() {
        this.getCache().close();
        while (!this.getCache().isClosed()) {
        }
        this.started.set(false);
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    private String getLogFileName() {
        String logFileName = this.getGemFireProperties().get("log-file");
        if (logFileName == null) {
            logFileName = DEFAULT_LOG_FILE_NAME;
        }
        return logFileName;
    }

    private String getStatisticArchiveFileName() {
        String statisticsArchiveFileName = this.getGemFireProperties().get("statistic-archive-file");
        if (statisticsArchiveFileName == null) {
            statisticsArchiveFileName = DEFAULT_STATISTIC_ARCHIVE_FILE_NAME;
        }
        return statisticsArchiveFileName;
    }

    private String getCacheXmlFileName() {
        String cacheXmlFileName = this.getGemFireProperties().get("cache-xml-file");
        if (cacheXmlFileName == null) {
            cacheXmlFileName = this.getDefaultCacheXmlFileName();
        }
        return cacheXmlFileName;
    }

    private File getCacheXmlFile() {
        String cacheXmlFileName = this.getCacheXmlFileName();
        File cacheXmlFile = new File(cacheXmlFileName);
        if (!cacheXmlFile.isAbsolute() && System.getProperty("catalina.base") != null) {
            cacheXmlFile = new File(System.getProperty("catalina.base") + "/conf/", cacheXmlFileName);
        }
        return cacheXmlFile;
    }

    public float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public void setEvictionHeapPercentage(String evictionHeapPercentage) {
        this.evictionHeapPercentage = Float.parseFloat(evictionHeapPercentage);
    }

    public float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public void setCriticalHeapPercentage(String criticalHeapPercentage) {
        this.criticalHeapPercentage = Float.parseFloat(criticalHeapPercentage);
    }

    public void setRebalance(boolean rebalance) {
        this.rebalance = rebalance;
    }

    public boolean getRebalance() {
        return this.rebalance;
    }

    private Map<String, String> getGemFireProperties() {
        return this.gemfireProperties;
    }

    public void setProperty(String name, String value) {
        if (name.equals("className")) {
            return;
        }
        boolean validProperty = name.startsWith("security-");
        if (!validProperty) {
            for (String gemfireProperty : AbstractDistributionConfig._getAttNames()) {
                if (!name.equals(gemfireProperty)) continue;
                validProperty = true;
                break;
            }
        }
        if (validProperty) {
            this.gemfireProperties.put(name, value);
        } else {
            this.getLogger().warn("The input property named " + name + " is not a valid GemFire property. It is being ignored.");
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }

    Properties createDistributedSystemProperties() {
        Properties properties = new Properties();
        properties.putAll(this.gemfireProperties);
        File cacheXmlFile = this.getCacheXmlFile();
        String absoluteCacheXmlFileName = cacheXmlFile.getAbsolutePath();
        if (this.getCacheXmlFileName().equals(this.getDefaultCacheXmlFileName()) && !cacheXmlFile.exists()) {
            absoluteCacheXmlFileName = DEFAULT_CACHE_XML_FILE;
        }
        properties.put("cache-xml-file", absoluteCacheXmlFileName);
        properties.put("log-file", this.getLogFile().getAbsolutePath());
        File statisticArchiveFile = this.getStatisticArchiveFile();
        if (statisticArchiveFile == null) {
            properties.remove("statistic-archive-file");
            properties.remove("statistic-sampling-enabled");
        } else {
            properties.put("statistic-archive-file", statisticArchiveFile.getAbsolutePath());
        }
        this.getLogger().info("Creating distributed system from: " + String.valueOf(properties));
        return properties;
    }

    private File getLogFile() {
        String logFileName = this.getLogFileName();
        File logFile = new File(logFileName);
        if (!logFile.isAbsolute()) {
            if (System.getProperty("catalina.base") != null) {
                logFile = new File(System.getProperty("catalina.base") + "/logs/", logFileName);
            } else if (System.getProperty("weblogic.Name") != null) {
                String weblogicName = System.getProperty("weblogic.Name");
                String separator = System.getProperty("file.separator");
                logFile = new File("servers" + separator + weblogicName + separator + "logs" + separator + logFileName);
            } else {
                logFile = new File(System.getProperty("gemfire.logdir"), logFileName);
            }
        }
        return logFile;
    }

    private File getStatisticArchiveFile() {
        String statisticsArchiveFileName;
        File statisticsArchiveFile = null;
        String statisticSamplingEnabled = this.getGemFireProperties().get("statistic-sampling-enabled");
        if (statisticSamplingEnabled != null && statisticSamplingEnabled.equals("true") && !(statisticsArchiveFile = new File(statisticsArchiveFileName = this.getStatisticArchiveFileName())).isAbsolute()) {
            if (System.getProperty("catalina.base") != null) {
                statisticsArchiveFile = new File(System.getProperty("catalina.base") + "/logs/", statisticsArchiveFileName);
            } else if (System.getProperty("weblogic.Name") != null) {
                String weblogicName = System.getProperty("weblogic.Name");
                String separator = System.getProperty("file.separator");
                statisticsArchiveFile = new File("servers" + separator + weblogicName + separator + "logs" + separator + statisticsArchiveFileName);
            } else {
                statisticsArchiveFile = new File(System.getProperty("gemfire.statisticsdir"), statisticsArchiveFileName);
            }
        }
        return statisticsArchiveFile;
    }

    private void initializeResourceManager() {
        ResourceManager rm = this.getCache().getResourceManager();
        float currentEvictionHeapPercentage = rm.getEvictionHeapPercentage();
        float currentCriticalHeapPercentage = rm.getCriticalHeapPercentage();
        if (this.getEvictionHeapPercentage() != currentEvictionHeapPercentage || this.getCriticalHeapPercentage() != currentCriticalHeapPercentage) {
            Object builder;
            if (this.getLogger().isDebugEnabled()) {
                builder = new StringBuilder();
                ((StringBuilder)builder).append("Previous eviction heap percentage=").append(currentEvictionHeapPercentage).append("; critical heap percentage=").append(currentCriticalHeapPercentage);
                this.getLogger().debug(((StringBuilder)builder).toString());
                ((StringBuilder)builder).setLength(0);
                ((StringBuilder)builder).append("Requested eviction heap percentage=").append(this.getEvictionHeapPercentage()).append("; critical heap percentage=").append(this.getCriticalHeapPercentage());
                this.getLogger().debug(((StringBuilder)builder).toString());
            }
            if (currentCriticalHeapPercentage == 0.0f) {
                try {
                    rm.setEvictionHeapPercentage(this.getEvictionHeapPercentage());
                    rm.setCriticalHeapPercentage(this.getCriticalHeapPercentage());
                }
                catch (IllegalArgumentException e) {
                    this.handleResourceManagerException(e, currentEvictionHeapPercentage, currentCriticalHeapPercentage);
                    rm.setEvictionHeapPercentage(currentEvictionHeapPercentage);
                    rm.setCriticalHeapPercentage(currentCriticalHeapPercentage);
                }
            } else if (this.getCriticalHeapPercentage() >= currentCriticalHeapPercentage) {
                try {
                    rm.setCriticalHeapPercentage(this.getCriticalHeapPercentage());
                    rm.setEvictionHeapPercentage(this.getEvictionHeapPercentage());
                }
                catch (IllegalArgumentException e) {
                    this.handleResourceManagerException(e, currentEvictionHeapPercentage, currentCriticalHeapPercentage);
                    rm.setCriticalHeapPercentage(currentCriticalHeapPercentage);
                    rm.setEvictionHeapPercentage(currentEvictionHeapPercentage);
                }
            } else {
                try {
                    rm.setEvictionHeapPercentage(this.getEvictionHeapPercentage());
                    rm.setCriticalHeapPercentage(this.getCriticalHeapPercentage());
                }
                catch (IllegalArgumentException e) {
                    this.handleResourceManagerException(e, currentEvictionHeapPercentage, currentCriticalHeapPercentage);
                    rm.setEvictionHeapPercentage(currentEvictionHeapPercentage);
                    rm.setCriticalHeapPercentage(currentCriticalHeapPercentage);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                builder = "Actual eviction heap percentage=" + rm.getEvictionHeapPercentage() + "; critical heap percentage=" + rm.getCriticalHeapPercentage();
                this.getLogger().debug((String)builder);
            }
        }
        ResourceManagerValidator.validateJavaStartupParameters(this.getCache());
    }

    private void handleResourceManagerException(IllegalArgumentException e, float currentEvictionHeapPercentage, float currentCriticalHeapPercentage) {
        String builder = "Caught exception attempting to set eviction heap percentage=" + this.getEvictionHeapPercentage() + " and critical heap percentage=" + this.getCriticalHeapPercentage() + ". The percentages will be set back to their previous values (eviction heap percentage=" + currentEvictionHeapPercentage + " and critical heap percentage=" + currentCriticalHeapPercentage + ").";
        this.getLogger().warn(builder, (Throwable)e);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cache=" + String.valueOf(this.cache) + "]";
    }

    protected abstract void createOrRetrieveCache();

    protected abstract void rebalanceCache();

    protected abstract String getDefaultCacheXmlFileName();
}

