/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEvent;

public class GatewayDeltaEventApplicationCacheListener
extends CacheListenerAdapter<String, GatewayDeltaEvent>
implements Declarable {
    private final Cache cache = CacheFactory.getAnyInstance();

    public void afterCreate(EntryEvent<String, GatewayDeltaEvent> event) {
        System.out.println("GatewayDeltaApplierCacheListener event: " + event);
        EntryEventImpl eventImpl = (EntryEventImpl)event;
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaApplierCacheListener: Received event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(".");
            this.cache.getLogger().fine(builder.toString());
        }
        Object callbackArgument = eventImpl.getRawCallbackArgument();
        System.out.println("GatewayDeltaApplierCacheListener callbackArgument: " + callbackArgument);
        if (callbackArgument instanceof GatewaySenderEventCallbackArgument) {
            GatewayDeltaEvent delta = (GatewayDeltaEvent)event.getNewValue();
            delta.apply(this.cache);
            System.out.println("Applied " + delta);
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaApplierCacheListener: Applied ").append(delta);
                this.cache.getLogger().fine(builder.toString());
            }
        }
    }

    public void init(Properties p) {
    }
}

