/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.modules.session.catalina.DeltaSession;
import com.gemstone.gemfire.modules.session.catalina.internal.DeltaSessionAttributeEvent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DeltaSessionUpdateAttributeEvent
implements DeltaSessionAttributeEvent {
    private String attributeName;
    private Object attributeValue;

    public DeltaSessionUpdateAttributeEvent() {
    }

    public DeltaSessionUpdateAttributeEvent(String attributeName, Object attributeValue) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public void apply(DeltaSession session) {
        session.localUpdateAttribute(this.attributeName, this.attributeValue);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.attributeName = DataSerializer.readString((DataInput)in);
        this.attributeValue = DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.attributeName, (DataOutput)out);
        DataSerializer.writeObject((Object)this.attributeValue, (DataOutput)out);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register((Instantiator)new Instantiator(DeltaSessionUpdateAttributeEvent.class, id){

            public DataSerializable newInstance() {
                return new DeltaSessionUpdateAttributeEvent();
            }
        });
    }

    public String toString() {
        return "DeltaSessionUpdateAttributeEvent[" + "attributeName=" + this.attributeName + "; attributeValue=" + this.attributeValue + "]";
    }
}

