/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.modules.session.catalina.AbstractSessionCache;
import com.gemstone.gemfire.modules.session.catalina.SessionManager;
import com.gemstone.gemfire.modules.session.catalina.callback.SessionExpirationCacheListener;
import com.gemstone.gemfire.modules.util.BootstrappingFunction;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import com.gemstone.gemfire.modules.util.RegionStatus;
import com.gemstone.gemfire.modules.util.SessionCustomExpiry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class ClientServerSessionCache
extends AbstractSessionCache {
    private ClientCache cache;
    protected static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.PARTITION_REDUNDANT.toString();
    protected static final boolean DEFAULT_ENABLE_LOCAL_CACHE = true;

    public ClientServerSessionCache(SessionManager sessionManager, ClientCache cache) {
        super(sessionManager);
        this.cache = cache;
    }

    @Override
    public void initialize() {
        this.bootstrapServers();
        try {
            this.createOrRetrieveRegion();
        }
        catch (Exception ex) {
            this.sessionManager.getLogger().fatal((Object)"Unable to create or retrieve region", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        this.operatingRegion = this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public String getDefaultRegionAttributesId() {
        return DEFAULT_REGION_ATTRIBUTES_ID;
    }

    @Override
    public boolean getDefaultEnableLocalCache() {
        return true;
    }

    @Override
    public void touchSessions(Set<String> sessionIds) {
        String regionAttributesID = this.getSessionManager().getRegionAttributesId().toLowerCase();
        if (regionAttributesID.startsWith("partition")) {
            Execution execution = FunctionService.onRegion(this.getSessionRegion()).withFilter(sessionIds);
            try {
                ResultCollector collector = execution.execute("touch-partitioned-region-entries", true, false, true);
                collector.getResult();
            }
            catch (Exception e) {
                this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
            }
        } else {
            Execution execution = FunctionService.onServers((RegionService)this.getCache()).withArgs((Object)new Object[]{this.sessionRegion.getFullPath(), sessionIds});
            try {
                ResultCollector collector = execution.execute("touch-replicated-region-entries", true, false, false);
                collector.getResult();
            }
            catch (Exception e) {
                this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isPeerToPeer() {
        return false;
    }

    @Override
    public boolean isClientServer() {
        return true;
    }

    @Override
    public Set<String> keySet() {
        return this.getSessionRegion().keySetOnServer();
    }

    @Override
    public int size() {
        HashSet<String> filters = new HashSet<String>();
        filters.add("test-key");
        Execution execution = FunctionService.onRegion(this.getSessionRegion()).withFilter(filters);
        ResultCollector collector = execution.execute("region-size-function", true, true, true);
        List result = (List)collector.getResult();
        return (Integer)result.get(0);
    }

    @Override
    public boolean isBackingCacheAvailable() {
        if (this.getSessionManager().isCommitValveFailfastEnabled()) {
            PoolImpl pool = (PoolImpl)PoolManager.find((String)this.getOperatingRegionName());
            return pool.isPrimaryUpdaterAlive();
        }
        return true;
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    private void bootstrapServers() {
        Execution execution = FunctionService.onServers((RegionService)this.cache);
        ResultCollector collector = execution.execute((Function)new BootstrappingFunction());
        try {
            collector.getResult();
        }
        catch (Exception e) {
            this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
        }
    }

    protected void createOrRetrieveRegion() {
        this.sessionRegion = this.cache.getRegion(this.getSessionManager().getRegionName());
        if (this.sessionRegion == null) {
            this.createSessionRegionOnServers();
            this.sessionRegion = this.createLocalSessionRegion();
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created session region: " + this.sessionRegion));
            }
        } else if (this.getSessionManager().getLogger().isDebugEnabled()) {
            this.getSessionManager().getLogger().debug((Object)("Retrieved session region: " + this.sessionRegion));
        }
    }

    private void createSessionRegionOnServers() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        Execution execution = FunctionService.onServer((RegionService)this.cache).withArgs((Object)configuration);
        ResultCollector collector = execution.execute("create-region-function");
        List results = (List)collector.getResult();
        for (RegionStatus status : results) {
            if (status != RegionStatus.INVALID) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("An exception occurred on the server while attempting to create or validate region named ").append(this.getSessionManager().getRegionName()).append(". See the server log for additional details.");
            throw new IllegalStateException(builder.toString());
        }
    }

    private Region<String, HttpSession> createLocalSessionRegion() {
        ClientRegionFactory factory = null;
        if (this.getSessionManager().getEnableLocalCache()) {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY_HEAP_LRU);
            int maxInactiveInterval = this.getSessionManager().getMaxInactiveInterval();
            if (maxInactiveInterval != -1) {
                factory.setStatisticsEnabled(true);
                factory.setCustomEntryIdleTimeout((CustomExpiry)new SessionCustomExpiry());
                factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
            }
        } else {
            factory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
            factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
        }
        Region region = factory.create(this.getSessionManager().getRegionName());
        if (!this.getSessionManager().getEnableLocalCache()) {
            region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS);
        }
        return region;
    }
}

