/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina.callback;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.modules.session.catalina.DeltaSession;
import com.gemstone.gemfire.modules.session.catalina.DeltaSessionManager;
import com.gemstone.gemfire.modules.util.ContextMapper;
import java.util.Properties;
import javax.servlet.http.HttpSession;

public class SessionExpirationCacheListener
extends CacheListenerAdapter<String, HttpSession>
implements Declarable {
    public void afterDestroy(EntryEvent<String, HttpSession> event) {
        DeltaSession session = null;
        if (event.getOperation() == Operation.EXPIRE_DESTROY) {
            session = (DeltaSession)event.getOldValue();
        } else {
            DeltaSessionManager m;
            Object callback = event.getCallbackArgument();
            if (callback != null && callback instanceof DeltaSession && (m = ContextMapper.getContext((session = (DeltaSession)callback).getContextName())) != null) {
                session.setOwner(m);
            }
        }
        if (session != null) {
            session.processExpired();
        }
    }

    public void init(Properties p) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof SessionExpirationCacheListener;
    }
}

