/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.bootstrap;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.modules.session.bootstrap.AbstractCache;

public class ClientServerCache
extends AbstractCache {
    protected static final String DEFAULT_CACHE_XML_FILE_NAME = "cache-client.xml";

    private ClientServerCache() {
    }

    public static AbstractCache getInstance() {
        return instance;
    }

    @Override
    protected void createOrRetrieveCache() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this + ": Creating cache");
        }
        try {
            this.cache = ClientCacheFactory.getAnyInstance();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        String message = null;
        if (this.cache == null) {
            this.cache = new ClientCacheFactory(this.createDistributedSystemProperties()).create();
            message = "Created ";
        } else {
            message = "Retrieved ";
        }
        this.getLogger().info(message + this.cache);
    }

    @Override
    protected void rebalanceCache() {
        this.getLogger().warn("The client cannot rebalance the server's cache.");
    }

    @Override
    protected String getDefaultCacheXmlFileName() {
        return DEFAULT_CACHE_XML_FILE_NAME;
    }

    static {
        instance = new ClientServerCache();
    }
}

