/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.gatewaydelta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SerializedCacheValue;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDelta;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDeltaCreateEvent;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDeltaDestroyEvent;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDeltaEventApplicationCacheListener;
import java.util.Properties;

public class GatewayDeltaForwarderCacheListener
extends CacheListenerAdapter<String, GatewayDelta>
implements Declarable {
    private final Cache cache;
    private LocalRegion gatewayDeltaRegion;

    public GatewayDeltaForwarderCacheListener() {
        this(CacheFactory.getAnyInstance());
    }

    public GatewayDeltaForwarderCacheListener(Cache cache) {
        this.cache = cache;
    }

    public void afterCreate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received create event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            String regionName = event.getRegion().getFullPath();
            String sessionId = (String)event.getKey();
            SerializedCacheValue scv = event.getSerializedNewValue();
            if (scv == null) {
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, EntryEventImpl.serialize((Object)event.getNewValue())));
            } else {
                System.out.println("GatewayDeltaForwarderCacheListener event.getSerializedNewValue().getSerializedValue(): " + event.getSerializedNewValue().getSerializedValue());
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, scv.getSerializedValue()));
            }
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received create event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void afterUpdate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received update event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            GatewayDelta session = (GatewayDelta)event.getNewValue();
            this.getGatewayDeltaRegion().put(event.getKey(), (Object)session.getCurrentGatewayDeltaEvent());
            session.setCurrentGatewayDeltaEvent(null);
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received update event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void afterDestroy(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() != null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received destroy event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            String sessionId = (String)event.getKey();
            this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaDestroyEvent(event.getRegion().getFullPath(), sessionId));
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received destroy event for session ").append((String)event.getKey()).append(" that either expired or originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void init(Properties p) {
    }

    private LocalRegion getGatewayDeltaRegion() {
        if (this.gatewayDeltaRegion == null) {
            this.gatewayDeltaRegion = this.createOrRetrieveGatewayDeltaRegion();
        }
        return this.gatewayDeltaRegion;
    }

    private LocalRegion createOrRetrieveGatewayDeltaRegion() {
        Region region = this.cache.getRegion("__gatewayDelta");
        if (region == null) {
            region = new RegionFactory().setScope(Scope.LOCAL).setDataPolicy(DataPolicy.EMPTY).setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL)).addCacheListener((CacheListener)new GatewayDeltaEventApplicationCacheListener()).create("__gatewayDelta");
        }
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Created gateway delta region: ").append(region);
            this.cache.getLogger().fine(builder.toString());
        }
        return (LocalRegion)region;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof GatewayDeltaForwarderCacheListener;
    }
}

