/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.session.StandardSession;
import org.apache.geode.modules.session.catalina.DeltaSession8;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.geode.modules.session.catalina.Tomcat8CommitSessionValve;

public class Tomcat8DeltaSessionManager
extends DeltaSessionManager<Tomcat8CommitSessionValve> {
    public void startInternal() throws LifecycleException {
        this.startInternalBase();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Starting"));
        }
        if (this.started.get()) {
            return;
        }
        this.fireLifecycleEvent("start", null);
        this.registerJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.registerCommitSessionValve();
        }
        this.initializeSessionCache();
        try {
            this.load();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new LifecycleException("Exception starting manager", (Throwable)e);
        }
        this.scheduleTimerTasks();
        this.started.set(true);
        this.setLifecycleState(LifecycleState.STARTING);
    }

    void setLifecycleState(LifecycleState newState) throws LifecycleException {
        this.setState(newState);
    }

    void startInternalBase() throws LifecycleException {
        super.startInternal();
    }

    public void stopInternal() throws LifecycleException {
        this.stopInternalBase();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Stopping"));
        }
        try {
            this.unload();
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Unable to unload sessions", (Throwable)e);
        }
        this.started.set(false);
        this.fireLifecycleEvent("stop", null);
        this.destroyInternalBase();
        this.getSessionsToTouch().clear();
        this.cancelTimer();
        this.unregisterJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.unregisterCommitSessionValve();
        }
        this.setLifecycleState(LifecycleState.STOPPING);
    }

    void stopInternalBase() throws LifecycleException {
        super.stopInternal();
    }

    void destroyInternalBase() throws LifecycleException {
        super.destroyInternal();
    }

    public int getMaxInactiveInterval() {
        return this.getContext().getSessionTimeout();
    }

    protected Pipeline getPipeline() {
        return this.getTheContext().getPipeline();
    }

    protected Tomcat8CommitSessionValve createCommitSessionValve() {
        return new Tomcat8CommitSessionValve();
    }

    public Context getTheContext() {
        return this.getContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.getContext().setSessionTimeout(interval);
    }

    protected StandardSession getNewSession() {
        return new DeltaSession8((Manager)this);
    }
}

