/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.internal.MakeNotStatic;

public class ValueWrapper
implements DataSerializable {
    private static final long serialVersionUID = 7931598505833835569L;
    private long casVersion;
    private byte[] value;
    private int flags;
    @MakeNotStatic
    private static final AtomicLong versionGenerator = new AtomicLong();

    public ValueWrapper() {
    }

    private ValueWrapper(byte[] value, long version, int flags) {
        this.value = value;
        this.casVersion = version;
        this.flags = flags;
    }

    public static ValueWrapper getWrappedValue(byte[] value, int flags) {
        return new ValueWrapper(value, versionGenerator.incrementAndGet(), flags);
    }

    public static ValueWrapper getDummyValue(long cas) {
        return new ValueWrapper(null, cas, 0);
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getVersion() {
        return this.casVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueWrapper) {
            ValueWrapper other = (ValueWrapper)obj;
            if (this.casVersion == other.casVersion) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.casVersion).hashCode();
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.casVersion = in.readLong();
        this.value = DataSerializer.readByteArray((DataInput)in);
        this.flags = in.readInt();
    }

    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.casVersion);
        DataSerializer.writeByteArray((byte[])this.value, (DataOutput)out);
        out.writeInt(this.flags);
    }
}

