/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules.gfsh;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.SystemUtils;
import org.apache.geode.test.junit.rules.RequiresGeodeHome;
import org.apache.geode.test.junit.rules.gfsh.GfshExecution;
import org.apache.geode.test.junit.rules.gfsh.GfshScript;
import org.assertj.core.api.Assertions;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class GfshRule
extends ExternalResource {
    private static final String DOUBLE_QUOTE = "\"";
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private List<GfshExecution> gfshExecutions;
    private Path gfsh;

    protected void before() throws IOException {
        this.gfsh = new RequiresGeodeHome().getGeodeHome().toPath().resolve("bin/gfsh");
        Assertions.assertThat((Path)this.gfsh).exists();
        this.gfshExecutions = new ArrayList<GfshExecution>();
        this.temporaryFolder.create();
    }

    protected void after() {
        this.gfshExecutions.stream().collect(Collectors.toList()).forEach(this::stopMembersQuietly);
        this.gfshExecutions.stream().map(GfshExecution::getProcess).map(Process::destroyForcibly).forEach(process -> {
            try {
                process.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.temporaryFolder.delete();
    }

    public TemporaryFolder getTemporaryFolder() {
        return this.temporaryFolder;
    }

    public Path getGfshPath() {
        return this.gfsh;
    }

    public GfshExecution execute(String ... commands) {
        return this.execute(GfshScript.of(commands));
    }

    public GfshExecution execute(GfshScript gfshScript) {
        GfshExecution gfshExecution;
        try {
            File workingDir = new File(this.temporaryFolder.getRoot(), gfshScript.getName());
            workingDir.mkdirs();
            Process process = this.toProcessBuilder(gfshScript, this.gfsh, workingDir).start();
            gfshExecution = new GfshExecution(process, workingDir);
            this.gfshExecutions.add(gfshExecution);
            gfshScript.awaitIfNecessary(gfshExecution);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return gfshExecution;
    }

    protected ProcessBuilder toProcessBuilder(GfshScript gfshScript, Path gfshPath, File workingDir) {
        ArrayList<String> commandsToExecute = new ArrayList<String>();
        commandsToExecute.add(gfshPath.toAbsolutePath().toString());
        for (String command : gfshScript.getCommands()) {
            commandsToExecute.add("-e " + command);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandsToExecute);
        processBuilder.directory(workingDir);
        List<String> extendedClasspath = gfshScript.getExtendedClasspath();
        if (!extendedClasspath.isEmpty()) {
            Map<String, String> environmentMap = processBuilder.environment();
            String classpathKey = "CLASSPATH";
            String existingJavaArgs = environmentMap.get(classpathKey);
            String specified = String.join((CharSequence)SystemUtils.PATH_SEPARATOR, extendedClasspath);
            String newValue = String.format("%s%s", existingJavaArgs == null ? "" : existingJavaArgs + ":", specified);
            environmentMap.put(classpathKey, newValue);
        }
        return processBuilder;
    }

    private void stopMembersQuietly(GfshExecution gfshExecution) {
        gfshExecution.getServerDirs().forEach(this::stopServerInDir);
        gfshExecution.getLocatorDirs().forEach(this::stopLocatorInDir);
    }

    private void stopServerInDir(File dir) {
        String stopServerCommand = "stop server --dir=" + this.quoteArgument(dir.toString());
        GfshScript stopServerScript = new GfshScript(stopServerCommand).withName("teardown-stop-server").awaitQuietly();
        this.execute(stopServerScript);
    }

    private void stopLocatorInDir(File dir) {
        String stopLocatorCommand = "stop locator --dir=" + this.quoteArgument(dir.toString());
        GfshScript stopServerScript = new GfshScript(stopLocatorCommand).withName("teardown-stop-locator").awaitQuietly();
        this.execute(stopServerScript);
    }

    private String quoteArgument(String argument) {
        if (!argument.startsWith(DOUBLE_QUOTE)) {
            argument = DOUBLE_QUOTE + argument;
        }
        if (!argument.endsWith(DOUBLE_QUOTE)) {
            argument = argument + DOUBLE_QUOTE;
        }
        return argument;
    }
}

