/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.assertj.core.api.Assertions;
import org.junit.Assert;

public class RequiresGeodeHome
extends SerializableExternalResource {
    private static final String GEODE_HOME_NOT_SET_MESSAGE = "This test requires a GEODE_HOME environment variable that points to the location of geode-assembly/build/install/apache-geode." + SystemUtils.LINE_SEPARATOR + "For instructions on how to set this variable if running tests through IntelliJ, see https://stackoverflow.com/a/32761503/3988499";

    protected void before() {
        this.getGeodeHome();
    }

    public File getGeodeHome() {
        String geodeHomePath = System.getenv("GEODE_HOME");
        Assert.assertNotNull((String)GEODE_HOME_NOT_SET_MESSAGE, (Object)geodeHomePath);
        File geodeHome = new File(geodeHomePath);
        Assertions.assertThat((File)geodeHome).exists();
        return geodeHome;
    }
}

