/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.geode.test.compiler.ClassBuilder;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class JarFileRule
extends SerializableExternalResource {
    private transient TemporaryFolder temporaryFolder = new TemporaryFolder();
    private transient ClassBuilder classBuilder = new ClassBuilder();
    private String className;
    private String jarName;
    private File jarFile;
    boolean makeJarLarge;

    public JarFileRule(String className, String jarName) {
        this(className, jarName, false);
    }

    public JarFileRule(String className, String jarName, boolean makeJarLarge) {
        this.className = className;
        this.jarName = jarName;
        this.makeJarLarge = makeJarLarge;
    }

    protected void before() throws IOException {
        this.temporaryFolder.create();
        this.jarFile = this.temporaryFolder.newFile(this.jarName);
        if (this.makeJarLarge) {
            this.classBuilder.writeJarFromContent(this.className, "public class " + this.className + "{String test = \"" + RandomStringUtils.randomAlphanumeric((int)10000) + "\";String test2 = \"" + RandomStringUtils.randomAlphanumeric((int)10000) + "\";String test3 = \"" + RandomStringUtils.randomAlphanumeric((int)10000) + "\";String test4 = \"" + RandomStringUtils.randomAlphanumeric((int)10000) + "\";}", this.jarFile);
        } else {
            this.classBuilder.writeJarFromName(this.className, this.jarFile);
        }
    }

    protected void after() {
        this.temporaryFolder.delete();
    }

    public File getJarFile() {
        Assertions.assertThat((File)this.jarFile).exists();
        return this.jarFile;
    }

    public String getJarName() {
        return this.jarName;
    }
}

