/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.geode.test.compiler.CompiledSourceCode;
import org.apache.geode.test.compiler.JavaCompiler;
import org.apache.geode.test.compiler.UncompiledSourceCode;
import org.assertj.core.api.Assertions;

public class JarBuilder {
    private final JavaCompiler javaCompiler = new JavaCompiler();

    public void buildJarFromClassNames(File outputJarFile, String ... classNames) throws IOException {
        UncompiledSourceCode[] uncompiledSourceCodes = (UncompiledSourceCode[])Arrays.stream(classNames).map(UncompiledSourceCode::fromClassName).toArray(UncompiledSourceCode[]::new);
        List<CompiledSourceCode> compiledSourceCodes = this.javaCompiler.compile(uncompiledSourceCodes);
        this.buildJar(outputJarFile, compiledSourceCodes);
    }

    public void buildJar(File outputJarFile, String ... sourceFileContents) throws IOException {
        List<CompiledSourceCode> compiledSourceCodes = this.javaCompiler.compile(sourceFileContents);
        this.buildJar(outputJarFile, compiledSourceCodes);
    }

    public void buildJar(File outputJarFile, File ... sourceFiles) throws IOException {
        List<CompiledSourceCode> compiledSourceCodes = this.javaCompiler.compile(sourceFiles);
        this.buildJar(outputJarFile, compiledSourceCodes);
    }

    private void buildJar(File outputJarFile, List<CompiledSourceCode> compiledSourceCodes) throws IOException {
        Assertions.assertThat((File)outputJarFile).doesNotExist();
        try (FileOutputStream outputStream = new FileOutputStream(outputJarFile);){
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
            for (CompiledSourceCode compiledSource : compiledSourceCodes) {
                String formattedName = compiledSource.className.replace(".", "/");
                if (!formattedName.endsWith(".class")) {
                    formattedName = formattedName.concat(".class");
                }
                JarEntry entry = new JarEntry(formattedName);
                entry.setTime(System.currentTimeMillis());
                jarOutputStream.putNextEntry(entry);
                jarOutputStream.write(compiledSource.compiledBytecode);
                jarOutputStream.closeEntry();
            }
            jarOutputStream.close();
        }
    }
}

