/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.junit.rules.ExternalResource;

public class TemporaryFileRule
extends ExternalResource {
    private final String directory;
    private Set<File> files;

    private TemporaryFileRule(String parentDirectory) {
        this.directory = parentDirectory;
    }

    public static TemporaryFileRule inUserHome() {
        return new TemporaryFileRule(System.getProperty("user.home"));
    }

    public static TemporaryFileRule inCurrentDir() {
        return new TemporaryFileRule(System.getProperty("user.dir"));
    }

    public static TemporaryFileRule inDirectory(String directory) {
        return new TemporaryFileRule(directory);
    }

    public void before() {
        this.files = new HashSet<File>();
    }

    public void after() {
        this.files.stream().filter(Objects::nonNull).filter(File::exists).forEach(File::delete);
    }

    public File newFile(String fileName) {
        return this.createFile(this.directory, fileName);
    }

    private File createFile(String directory, String fileName) {
        File file = new File(directory, fileName);
        try {
            if (!file.createNewFile()) {
                throw new IllegalStateException("The specified file " + file.getAbsolutePath() + " already exists.");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException attempting to create file " + file.getAbsolutePath() + ".", e);
        }
        file.deleteOnExit();
        this.files.add(file);
        return file;
    }
}

