/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.geode.CancelException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionMessageObserver;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.dunit.DUnitBlackboard;
import org.apache.geode.test.dunit.Disconnect;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.DistributedTestFixture;
import org.apache.geode.test.dunit.internal.TestHistoryLogger;
import org.apache.geode.test.dunit.rules.DistributedRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTestName;
import org.apache.geode.test.version.VersionManager;
import org.apache.logging.log4j.Logger;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;

@Deprecated
public abstract class JUnit4DistributedTestCase
implements DistributedTestFixture,
Serializable {
    protected static final Logger logger = LogService.getLogger();
    protected static InternalDistributedSystem system;
    private static Class lastSystemCreatedInTest;
    private static Properties lastSystemProperties;
    private static volatile String testMethodName;
    private static DUnitBlackboard blackboard;
    private static final boolean logPerTest;
    private final DistributedTestFixture distributedTestFixture;
    @Rule
    public SerializableTestName testNameForDistributedTestCase = new SerializableTestName();

    public JUnit4DistributedTestCase() {
        this(null);
    }

    protected JUnit4DistributedTestCase(DistributedTestFixture distributedTestFixture) {
        this.distributedTestFixture = distributedTestFixture == null ? this : distributedTestFixture;
    }

    @BeforeClass
    public static void initializeDistributedTestCase() {
        DUnitLauncher.launchIfNeeded(true);
    }

    public static void initializeBlackboard() {
        blackboard = new DUnitBlackboard();
    }

    protected static void deleteBACKUPDiskStoreFile(File file) {
        if (file.getName().startsWith("BACKUPDiskStore-") || file.getName().startsWith("ConfigDiskDir_")) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public static void cleanDiskDirs() {
        FileUtils.deleteQuietly((File)JUnit4CacheTestCase.getDiskDir());
        FileUtils.deleteQuietly((File)JUnit4CacheTestCase.getDiskDir());
        Arrays.stream(new File(".").listFiles()).forEach(JUnit4DistributedTestCase::deleteBACKUPDiskStoreFile);
    }

    @Override
    public final String getName() {
        if (this.distributedTestFixture != this) {
            return this.distributedTestFixture.getName();
        }
        return this.testNameForDistributedTestCase.getMethodName();
    }

    public final Class<? extends DistributedTestFixture> getTestClass() {
        return this.distributedTestFixture.getClass();
    }

    @Deprecated
    public final void setSystem(Properties props, DistributedSystem ds) {
        system = (InternalDistributedSystem)ds;
        lastSystemProperties = props;
        lastSystemCreatedInTest = this.getTestClass();
    }

    public final InternalDistributedSystem getSystem(Properties props) {
        if (system == null) {
            system = InternalDistributedSystem.getAnyInstance();
        }
        if (system == null || !system.isConnected()) {
            Properties p = DistributedTestUtils.getAllDistributedSystemProperties(props);
            lastSystemCreatedInTest = this.getTestClass();
            if (logPerTest) {
                String testMethod = JUnit4DistributedTestCase.getTestMethodName();
                String testName = lastSystemCreatedInTest.getName() + "-" + testMethod;
                String oldLogFile = p.getProperty("log-file");
                p.put("log-file", oldLogFile.replace("system.log", testName + ".log"));
                String oldStatFile = p.getProperty("statistic-archive-file");
                p.put("statistic-archive-file", oldStatFile.replace("statArchive.gfs", testName + ".gfs"));
            }
            if (VersionManager.getInstance().getCurrentVersionOrdinal() < 75) {
                p.remove("validate-serializable-objects");
                p.remove("serializable-object-filter");
            }
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
            lastSystemProperties = p;
        } else {
            boolean needNewSystem;
            block13: {
                needNewSystem = false;
                if (!this.getTestClass().equals(lastSystemCreatedInTest)) {
                    Properties newProps = DistributedTestUtils.getAllDistributedSystemProperties(props);
                    boolean bl = needNewSystem = !newProps.equals(lastSystemProperties);
                    if (needNewSystem) {
                        logger.info("Test class has changed and the new DS properties are not an exact match. Forcing DS disconnect. Old props = " + String.valueOf(lastSystemProperties) + "new props=" + String.valueOf(newProps));
                    }
                } else {
                    String value;
                    String key;
                    Properties activeProps = system.getConfig().toProperties();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        key = (String)entry.getKey();
                        if (key.startsWith("security-") || (value = (String)entry.getValue()).equals(activeProps.getProperty(key))) continue;
                        needNewSystem = true;
                        logger.info("Forcing DS disconnect. For property " + key + " old value = " + activeProps.getProperty(key) + " new value = " + value);
                        break;
                    }
                    try {
                        activeProps = system.getConfig().toSecurityProperties();
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            key = (String)entry.getKey();
                            if (!key.startsWith("security-") || (value = (String)entry.getValue()).equals(activeProps.getProperty(key))) continue;
                            needNewSystem = true;
                            logger.info("Forcing DS disconnect. For property " + key + " old value = " + activeProps.getProperty(key) + " new value = " + value);
                            break;
                        }
                    }
                    catch (NoSuchMethodError e) {
                        if (VersionManager.getInstance().getCurrentVersionOrdinal() < 85) break block13;
                        throw new IllegalStateException("missing method", e);
                    }
                }
            }
            if (needNewSystem) {
                logger.info("Disconnecting from current DS in order to make a new one");
                JUnit4DistributedTestCase.disconnectFromDS();
                this.getSystem(props);
            }
        }
        return system;
    }

    public final InternalDistributedSystem getSystem() {
        return this.getSystem(this.getDistributedSystemProperties());
    }

    public final InternalDistributedSystem basicGetSystem() {
        return system;
    }

    public final void nullSystem() {
        system = null;
    }

    public static InternalDistributedSystem getSystemStatic() {
        return system;
    }

    public final InternalDistributedSystem getLonerSystem() {
        Properties props = this.getDistributedSystemProperties();
        props.put("mcast-port", "0");
        props.put("locators", "");
        return this.getSystem(props);
    }

    public final boolean isConnectedToDS() {
        return system != null && system.isConnected();
    }

    @Override
    public Properties getDistributedSystemProperties() {
        if (this.distributedTestFixture != this) {
            return this.distributedTestFixture.getDistributedSystemProperties();
        }
        return this.defaultGetDistributedSystemProperties();
    }

    final Properties defaultGetDistributedSystemProperties() {
        return new Properties();
    }

    public static void disconnectAllFromDS() {
        Disconnect.disconnectAllFromDS();
    }

    public static void disconnectFromDS() {
        if (system != null) {
            system.disconnect();
            system = null;
        }
        Disconnect.disconnectFromDS();
    }

    public static DUnitBlackboard getBlackboard() {
        return blackboard;
    }

    public static String getTestMethodName() {
        return testMethodName;
    }

    private static void setTestMethodName(String testMethodName) {
        JUnit4DistributedTestCase.testMethodName = testMethodName;
    }

    public final String getUniqueName() {
        Assertions.assertThat((String)this.getName()).isNotNull();
        return this.getTestClass().getSimpleName() + "_" + this.getName();
    }

    @Before
    public final void setUpDistributedTestCase() throws Exception {
        this.preSetUp();
        this.doSetUpDistributedTestCase();
        this.postSetUp();
    }

    private void doSetUpDistributedTestCase() {
        String methodName = this.getName();
        TestHistoryLogger.logTestHistory(this.getTestClass().getSimpleName(), methodName);
        JUnit4DistributedTestCase.setUpVM(methodName, JUnit4DistributedTestCase.getDefaultDiskStoreName(0, -1, methodName));
        for (int hostIndex = 0; hostIndex < Host.getHostCount(); ++hostIndex) {
            Host host = Host.getHost(hostIndex);
            for (int vmIndex = 0; vmIndex < host.getVMCount(); ++vmIndex) {
                String vmDefaultDiskStoreName = JUnit4DistributedTestCase.getDefaultDiskStoreName(hostIndex, vmIndex, methodName);
                host.getVM(vmIndex).invoke("setupVM", () -> JUnit4DistributedTestCase.setUpVM(methodName, vmDefaultDiskStoreName));
            }
        }
        this.logTestStart();
    }

    @Override
    public void preSetUp() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.preSetUp();
        }
    }

    @Override
    public void postSetUp() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.postSetUp();
        }
    }

    private static String getDefaultDiskStoreName(int hostIndex, int vmIndex, String methodName) {
        return "DiskStore-" + hostIndex + "-" + vmIndex + "-" + methodName;
    }

    private static void setUpVM(String methodName, String defaultDiskStoreName) {
        ((AbstractStringAssert)Assertions.assertThat((String)methodName).as("methodName must not be null", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)defaultDiskStoreName).as("defaultDiskStoreName must not be null", new Object[0])).isNotNull();
        JUnit4DistributedTestCase.setTestMethodName(methodName);
        GemFireCacheImpl.setDefaultDiskStoreName((String)defaultDiskStoreName);
        JUnit4DistributedTestCase.setUpCreationStackGenerator();
    }

    private void logTestStart() {
        System.out.println("\n\n[setup] START TEST " + this.getTestClass().getSimpleName() + "." + testMethodName + "\n\n");
    }

    private static void setUpCreationStackGenerator() {
        InternalDistributedSystem.TEST_CREATION_STACK_GENERATOR.set(config -> {
            String[] validAttributeNames;
            StringBuilder sb = new StringBuilder();
            for (String attName : validAttributeNames = config.getAttributeNames()) {
                Object actualAtt = config.getAttributeObject(attName);
                String actualAttStr = actualAtt.toString();
                sb.append("  ");
                sb.append(attName);
                sb.append("=\"");
                if (actualAtt.getClass().isArray()) {
                    actualAttStr = InternalDistributedSystem.arrayToString((Object)actualAtt);
                }
                sb.append(actualAttStr);
                sb.append("\"");
                sb.append("\n");
            }
            return new Throwable("Creating distributed system with the following configuration:\n" + String.valueOf(sb));
        });
    }

    @After
    public final void tearDownDistributedTestCase() throws Exception {
        try {
            try {
                this.preTearDownAssertions();
            }
            finally {
                this.preTearDown();
                this.doTearDownDistributedTestCase();
            }
        }
        finally {
            this.postTearDown();
            this.postTearDownAssertions();
            System.out.println("\n\n[setup] END TEST " + this.getTestClass().getSimpleName() + "." + testMethodName + "\n\n");
        }
    }

    private void doTearDownDistributedTestCase() throws Exception {
        Invoke.invokeInEveryVM("tearDownCreationStackGenerator", JUnit4DistributedTestCase::tearDownCreationStackGenerator);
        if (logPerTest) {
            JUnit4DistributedTestCase.disconnectAllFromDS();
        }
        JUnit4DistributedTestCase.cleanupAllVms();
        if (!this.getDistributedSystemProperties().isEmpty()) {
            JUnit4DistributedTestCase.disconnectAllFromDS();
        }
    }

    @Override
    public void preTearDown() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.preTearDown();
        }
    }

    @Override
    public void postTearDown() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.postTearDown();
        }
    }

    @Override
    public void preTearDownAssertions() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.preTearDownAssertions();
        }
    }

    @Override
    public void postTearDownAssertions() throws Exception {
        if (this.distributedTestFixture != this) {
            this.distributedTestFixture.postTearDownAssertions();
        }
    }

    public static void cleanupAllVms() {
        JUnit4DistributedTestCase.tearDownVM();
        Invoke.invokeInEveryVM("tearDownVM", JUnit4DistributedTestCase::tearDownVM);
        Invoke.invokeInLocator(() -> {
            DistributionMessageObserver.setInstance(null);
            DistributedTestUtils.unregisterInstantiatorsInThisVM();
        });
        DUnitLauncher.closeAndCheckForSuspects();
    }

    private static void tearDownVM() {
        JUnit4DistributedTestCase.closeCache();
        DistributedRule.TearDown.tearDownInVM();
        JUnit4DistributedTestCase.cleanDiskDirs();
    }

    private static void closeCache() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            JUnit4DistributedTestCase.destroyRegions((Cache)cache);
            cache.close();
        }
    }

    protected static void destroyRegions(Cache cache) {
        if (cache != null && !cache.isClosed()) {
            try {
                for (Region root : cache.rootRegions()) {
                    String regionFullPath;
                    String string = regionFullPath = root == null ? null : root.getFullPath();
                    if (root.isDestroyed() || root instanceof HARegion || root instanceof PartitionedRegion) continue;
                    try {
                        root.localDestroyRegion((Object)"teardown");
                    }
                    catch (Throwable t) {
                        logger.error("Failure during tearDown destroyRegions for " + regionFullPath, t);
                    }
                }
            }
            catch (CancelException ce) {
                logger.info("Cache is closing, no need to destroy regions");
            }
        }
    }

    private static void tearDownCreationStackGenerator() {
        InternalDistributedSystem.TEST_CREATION_STACK_GENERATOR.set(InternalDistributedSystem.DEFAULT_CREATION_STACK_GENERATOR);
    }

    static {
        logPerTest = Boolean.getBoolean("dunitLogPerTest");
    }
}

