/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.SerializableCallable;
import org.apache.geode.test.dunit.internal.DUnitHost;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.dunit.internal.Master;
import org.apache.geode.test.dunit.internal.MasterRemote;
import org.apache.geode.test.dunit.internal.MethodInvokerResult;
import org.apache.geode.test.dunit.internal.ProcessManager;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.StandAloneDUnitEnv;
import org.apache.geode.test.dunit.internal.VMEventNotifier;
import org.apache.geode.test.greplogs.ExpectedStrings;
import org.apache.geode.test.greplogs.LogConsumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Assert;

public class DUnitLauncher {
    public static final String logLevel = System.getProperty("log-level", "info");
    public static final String LOG4J = System.getProperty("log4j.configurationFile");
    public static final boolean MAKE_NEW_WORKING_DIRS = Boolean.getBoolean("makeNewWorkingDirsOnBounce");
    static int locatorPort;
    public static int NUM_VMS;
    public static final int DEBUGGING_VM_NUM = -1;
    static final int LOCATOR_VM_NUM = -2;
    static final long STARTUP_TIMEOUT = 120000L;
    static final String STARTUP_TIMEOUT_MESSAGE = "VMs did not start up within 120 seconds";
    private static final String SUSPECT_FILENAME_PREFIX = "dunit_suspect";
    public static final String DUNIT_DIR = "dunit";
    public static final String WORKSPACE_DIR_PARAM = "WORKSPACE_DIR";
    public static final boolean LOCATOR_LOG_TO_DISK;
    static final String MASTER_PARAM = "DUNIT_MASTER";
    public static final String REMOTE_STUB_PORT_PARAM = "DUnitLauncher.REMOTE_STUB_PORT";
    public static final String RMI_PORT_PARAM = "gemfire.DUnitLauncher.RMI_PORT";
    public static final String RMI_HOST_PARAM = "gemfire.DUnitLauncher.RMI_HOST";
    public static final String VM_NUM_PARAM = "gemfire.DUnitLauncher.VM_NUM";
    public static final String VM_VERSION_PARAM = "gemfire.DUnitLauncher.VM_VERSION";
    private static final String LAUNCHED_PROPERTY = "gemfire.DUnitLauncher.LAUNCHED";
    private static final VMEventNotifier vmEventNotifier;
    private static Master master;

    private DUnitLauncher() {
    }

    private static boolean isHydra() {
        try {
            Class<?> clazz = Class.forName("hydra.TestConfig");
            Method getInstance = clazz.getMethod("getInstance", new Class[0]);
            getInstance.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void launchIfNeeded() {
        DUnitLauncher.launchIfNeeded(true);
    }

    public static void launchIfNeeded(boolean launchLocator) {
        if (System.getProperties().contains(VM_NUM_PARAM)) {
            return;
        }
        if (!DUnitLauncher.isHydra() && !DUnitLauncher.isLaunched()) {
            try {
                DUnitLauncher.launch(launchLocator);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to launch dunit VMs", e);
            }
        }
        Host.setAllVMsToCurrentVersion();
    }

    public static void launchIfNeeded(int vmCount) {
        NUM_VMS = vmCount;
        DUnitLauncher.launchIfNeeded();
    }

    public static void launchIfNeeded(int vmCount, boolean launchLocator) {
        NUM_VMS = vmCount;
        DUnitLauncher.launchIfNeeded(launchLocator);
    }

    public static boolean isLaunched() {
        return Boolean.getBoolean(LAUNCHED_PROPERTY);
    }

    public static String getLocatorString() {
        return "localhost[" + locatorPort + "]";
    }

    private static void launch(boolean launchLocator) throws AlreadyBoundException, IOException, InterruptedException, NotBoundException {
        DUnitLauncher.deleteDunitSuspectFiles();
        int namingPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Registry registry = LocateRegistry.createRegistry(namingPort);
        System.setProperty(RMI_PORT_PARAM, "" + namingPort);
        JUnit4DistributedTestCase.initializeBlackboard();
        ProcessManager processManager = new ProcessManager(namingPort, registry);
        master = new Master(registry, processManager);
        registry.bind(MASTER_PARAM, master);
        System.setProperty("Locator.inhibitDMBanner", "true");
        System.setProperty("gemfire.use-ephemeral-ports", "true");
        Runtime.getRuntime().addShutdownHook(new Thread(processManager::killVMs));
        if (launchLocator) {
            processManager.launchVM(-2);
            if (!processManager.waitForVMs(120000L)) {
                throw new RuntimeException(STARTUP_TIMEOUT_MESSAGE);
            }
            locatorPort = DUnitLauncher.startLocator(registry);
        }
        DUnitLauncher.init(master);
        for (int i = 0; i < NUM_VMS; ++i) {
            processManager.launchVM(i);
        }
        if (!processManager.waitForVMs(120000L)) {
            throw new RuntimeException(STARTUP_TIMEOUT_MESSAGE);
        }
        DUnitHost host = new DUnitHost(InetAddress.getLocalHost().getCanonicalHostName(), processManager, vmEventNotifier);
        host.init(NUM_VMS, launchLocator);
    }

    public static Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        p.setProperty("locators", DUnitLauncher.getLocatorString());
        p.setProperty("mcast-port", "0");
        p.setProperty("enable-cluster-configuration", "false");
        p.setProperty("use-cluster-configuration", "false");
        p.setProperty("validate-serializable-objects", "true");
        p.setProperty("log-level", logLevel);
        return p;
    }

    private static void addSuspectFileAppender(String workspaceDir) {
        String suspectFilename = DUnitLauncher.createDunitSuspectFile(DUnitEnv.get().getId(), workspaceDir).getAbsolutePath();
        Logger mainLogger = LogManager.getLogger((String)"org.apache.geode");
        if (!(mainLogger instanceof org.apache.logging.log4j.core.Logger)) {
            System.err.format("Unable to configure suspect file appender - cannot retrieve LoggerContext from type: %s\n", mainLogger.getClass().getName());
            return;
        }
        LoggerContext appenderContext = ((org.apache.logging.log4j.core.Logger)mainLogger).getContext();
        PatternLayout layout = PatternLayout.createLayout((String)"[%level{lowerCase=true} %date{yyyy/MM/dd HH:mm:ss.SSS z} <%thread> tid=%tid] %message%n%throwable%n", null, null, null, (Charset)Charset.defaultCharset(), (boolean)true, (boolean)false, (String)"", (String)"");
        FileAppender fileAppender = FileAppender.createAppender((String)suspectFilename, (String)"true", (String)"false", (String)DUnitLauncher.class.getName(), (String)"true", (String)"false", (String)"false", (String)"0", (Layout)layout, null, null, null, (Configuration)appenderContext.getConfiguration());
        fileAppender.start();
        LoggerConfig loggerConfig = appenderContext.getConfiguration().getLoggerConfig("org.apache.geode");
        loggerConfig.addAppender((Appender)fileAppender, Level.INFO, null);
    }

    private static int startLocator(Registry registry) throws IOException, NotBoundException {
        File locatorLogFile;
        int port;
        RemoteDUnitVMIF remote = (RemoteDUnitVMIF)registry.lookup("vm-2");
        MethodInvokerResult result = remote.executeMethodOnObject(new SerializableCallable(port = AvailablePortHelper.getRandomAvailableTCPPort(), locatorLogFile = LOCATOR_LOG_TO_DISK ? new File("locator-" + port + ".log") : new File("")){
            final /* synthetic */ int val$port;
            final /* synthetic */ File val$locatorLogFile;
            {
                this.val$port = n;
                this.val$locatorLogFile = file;
            }

            @Override
            public Object call() throws IOException {
                Properties p = DUnitLauncher.getDistributedSystemProperties();
                p.setProperty("jmx-manager", "false");
                p.setProperty("enable-management-rest-service", "false");
                p.setProperty("enable-cluster-configuration", "false");
                System.setProperty("gemfire.bypass-discovery", "true");
                p.setProperty("disable-auto-reconnect", "true");
                try {
                    Locator.startLocatorAndDS((int)this.val$port, (File)this.val$locatorLogFile, (Properties)p);
                    locatorPort = this.val$port;
                }
                finally {
                    System.getProperties().remove("gemfire.bypass-discovery");
                }
                return locatorPort;
            }
        }, "call");
        if (result.getException() != null) {
            RuntimeException ex = new RuntimeException("Failed to start locator", result.getException());
            ex.printStackTrace();
            throw ex;
        }
        return (Integer)result.getResult();
    }

    public static void init(MasterRemote master) {
        DUnitEnv.set(new StandAloneDUnitEnv(master));
        DUnitLauncher.addSuspectFileAppender(DUnitLauncher.getWorkspaceDir());
        System.setProperty("gemfire.free-off-heap-memory", "true");
        System.setProperty(LAUNCHED_PROPERTY, "true");
    }

    private static List<File> getDunitSuspectFiles() {
        File[] suspectFiles = DUnitLauncher.getDunitSuspectsDir().listFiles((dir, name) -> name.startsWith(SUSPECT_FILENAME_PREFIX));
        if (suspectFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(suspectFiles);
    }

    private static File getDunitSuspectsDir() {
        return Paths.get(DUnitLauncher.getWorkspaceDir(), new String[0]).toFile();
    }

    private static void deleteDunitSuspectFiles() {
        DUnitLauncher.getDunitSuspectFiles().forEach(File::delete);
    }

    private static File createDunitSuspectFile(int vmId, String workingDir) {
        File dunitSuspect = new File(DUnitLauncher.getDunitSuspectsDir(), DUnitLauncher.getSuspectFileName((String)(switch (vmId) {
            case -2 -> "locator";
            case -1 -> "local";
            default -> "vm" + vmId;
        })));
        dunitSuspect.deleteOnExit();
        return dunitSuspect;
    }

    private static String getWorkspaceDir() {
        String workspaceDir = System.getProperty(WORKSPACE_DIR_PARAM);
        workspaceDir = workspaceDir == null ? new File(".").getAbsolutePath() : workspaceDir;
        return workspaceDir;
    }

    public static void closeAndCheckForSuspects(int vmIndex) {
        String suffix = "vm" + vmIndex;
        String fileName = DUnitLauncher.getSuspectFileName(suffix);
        File[] suspectFiles = DUnitLauncher.getDunitSuspectsDir().listFiles((dir, name) -> name.startsWith(fileName));
        DUnitLauncher.closeAndCheckForSuspects(Arrays.asList(suspectFiles));
    }

    private static String getSuspectFileName(String suffix) {
        return String.format("%s-%s.log", SUSPECT_FILENAME_PREFIX, suffix);
    }

    public static void closeAndCheckForSuspects(List<File> suspectFiles) {
        StringBuilder suspectStringCollector = new StringBuilder();
        for (File suspect : suspectFiles) {
            DUnitLauncher.checkSuspectFile(suspect, suspectStringCollector);
        }
        if (suspectStringCollector.length() != 0) {
            System.err.println("Suspicious strings were written to the log during this run.\nFix the strings or use IgnoredException.addIgnoredException to ignore.\n" + String.valueOf(suspectStringCollector));
            Assert.fail((String)("Suspicious strings were written to the log during this run.\nFix the strings or use IgnoredException.addIgnoredException to ignore.\n" + String.valueOf(suspectStringCollector)));
        }
    }

    public static void closeAndCheckForSuspects() {
        if (!DUnitLauncher.isLaunched()) {
            return;
        }
        List<File> suspectFiles = DUnitLauncher.getDunitSuspectFiles();
        if (suspectFiles.isEmpty()) {
            throw new IllegalStateException("No dunit suspect log files found in '" + DUnitLauncher.getDunitSuspectsDir().getAbsolutePath() + "' - perhaps a rule that is cleaning up before suspect processing has already run.");
        }
        DUnitLauncher.closeAndCheckForSuspects(suspectFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSuspectFile(File suspectFile, StringBuilder suspectStringCollector) {
        BufferedReader buffReader;
        FileChannel fileChannel;
        List<Pattern> expectedStrings = ExpectedStrings.create(DUNIT_DIR);
        LogConsumer logConsumer = new LogConsumer(true, expectedStrings, suspectFile.getName(), 5);
        try {
            fileChannel = new FileOutputStream(suspectFile, true).getChannel();
            buffReader = new BufferedReader(new FileReader(suspectFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            try {
                String line;
                while ((line = buffReader.readLine()) != null) {
                    String suspectString = logConsumer.consume(line);
                    if (suspectString == null) continue;
                    suspectStringCollector.append(suspectString);
                }
            }
            catch (IOException e) {
                System.err.println("Could not read the suspect string output file: " + String.valueOf(e));
            }
            try {
                fileChannel.truncate(0L);
            }
            catch (IOException e) {
                System.err.println("Could not truncate the suspect string output file: " + String.valueOf(e));
            }
        }
        finally {
            try {
                buffReader.close();
                fileChannel.close();
            }
            catch (IOException e) {
                System.err.println("Could not close the suspect string output file: " + String.valueOf(e));
            }
        }
    }

    static {
        NUM_VMS = 4;
        LOCATOR_LOG_TO_DISK = Boolean.getBoolean("locatorLogToDisk");
        vmEventNotifier = new VMEventNotifier();
    }
}

