/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.util.Properties;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AuthInitialize;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.templates.UserPasswordAuthInit;

public class UserPasswordWithExtraPropsAuthInit
extends UserPasswordAuthInit {
    public static final String SECURITY_PREFIX = "security-";
    public static final String EXTRA_PROPS = "security-keep-extra-props";

    public static AuthInitialize create() {
        return new UserPasswordWithExtraPropsAuthInit();
    }

    public Properties getCredentials(Properties securityProperties, DistributedMember server, boolean isPeer) throws AuthenticationFailedException {
        Properties securityPropertiesCopy = super.getCredentials(securityProperties, server, isPeer);
        String extraProps = securityProperties.getProperty(EXTRA_PROPS);
        if (extraProps != null) {
            for (Object o : securityProperties.keySet()) {
                String key = (String)o;
                if (!key.startsWith(SECURITY_PREFIX) || key.equalsIgnoreCase("security-username") || key.equalsIgnoreCase("security-password") || key.equalsIgnoreCase(EXTRA_PROPS)) continue;
                securityPropertiesCopy.setProperty(key, securityProperties.getProperty(key));
            }
            this.securityLogWriter.fine("got everything and now have: " + String.valueOf(securityPropertiesCopy.keySet()));
        }
        return securityPropertiesCopy;
    }
}

