/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Time;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.geode.management.internal.cli.ResultHandler;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.geode.management.internal.cli.shell.jline.GfshUnsupportedTerminal;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class HeadlessGfsh
implements ResultHandler {
    public static final String ERROR_RESULT = "_$_ERROR_RESULT";
    private final HeadlessGfshShell shell;
    private final HeadlessGfshConfig config;
    private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
    private long timeout;
    public String outputString = null;

    public HeadlessGfsh(String name, int timeout, String parentDir) throws IOException {
        this(name, timeout, null, parentDir);
    }

    public HeadlessGfsh(String name, int timeout, Properties envProps, String parentDir) throws IOException {
        this.timeout = timeout;
        this.config = new HeadlessGfshConfig(name, parentDir);
        String logFilePath = this.config.getLogFilePath();
        System.setProperty("gfsh.log.file", logFilePath);
        File logFile = new File(logFilePath);
        logFile.getParentFile().mkdirs();
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        System.setProperty("jline.terminal", GfshUnsupportedTerminal.class.getName());
        this.shell = new HeadlessGfshShell(name, this, this.config);
        this.shell.setEnvProperty("APP_RESULT_VIEWER", "non-basic");
        if (envProps != null) {
            for (String key : envProps.stringPropertyNames()) {
                this.shell.setEnvProperty(key, envProps.getProperty(key));
            }
        }
        this.shell.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean executeCommand(String command) {
        boolean success = false;
        try {
            this.outputString = null;
            success = this.shell.executeScriptLine(command);
        }
        catch (Exception e) {
            this.outputString = e.getMessage();
        }
        if (!success && this.shell.output != null && this.outputString == null) {
            this.outputString = this.shell.output.toString();
            this.shell.output.reset();
        }
        return success;
    }

    public int getCommandExecutionStatus() {
        return this.shell.getCommandExecutionStatus();
    }

    public void handleExecutionResult(Object result, String sysout) {
        this.queue.add(result);
        this.outputString = sysout;
    }

    public CommandResult getResult() throws InterruptedException {
        if (this.shell.stopCalledThroughAPI) {
            return null;
        }
        Object result = this.queue.poll(this.timeout, TimeUnit.SECONDS);
        this.queue.clear();
        if (result instanceof CommandResult) {
            return (CommandResult)result;
        }
        if (result == null || ERROR_RESULT.equals(result)) {
            return new CommandResult(ResultModel.createError((String)this.outputString));
        }
        return new CommandResult(ResultModel.createError((String)result.toString()));
    }

    public void clear() {
        this.queue.clear();
        this.outputString = null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void clearEvents() {
        this.queue.clear();
        this.outputString = null;
    }

    public void terminate() {
        this.shell.terminate();
    }

    public Gfsh getGfsh() {
        return this.shell;
    }

    public boolean isConnectedAndReady() {
        return this.shell.isConnectedAndReady();
    }

    public String getErrorString() {
        return this.shell.errorString;
    }

    public boolean hasError() {
        return this.shell.hasError();
    }

    public String getError() {
        return this.shell.errorString;
    }

    LinkedBlockingQueue<Object> getQueue() {
        return this.queue;
    }

    public Path getGfshLogFile() {
        return Paths.get(this.config.getLogFilePath(), new String[0]);
    }

    static class HeadlessGfshConfig
    extends GfshConfig {
        private final File parentDir;
        private final String fileNamePrefix;
        private final String logFilePath;
        private String generatedHistoryFileName = null;

        public HeadlessGfshConfig(String name, String parentDir) throws IOException {
            this.fileNamePrefix = HeadlessGfshConfig.isDUnitTest(name) ? name : "non-hydra-client";
            this.parentDir = new File(parentDir);
            Files.createDirectories(this.parentDir.toPath(), new FileAttribute[0]);
            this.logFilePath = new File(this.parentDir, this.getFileNamePrefix() + "-gfsh.log").getAbsolutePath();
        }

        private static boolean isDUnitTest(String name) {
            String[] split;
            boolean isDUnitTest = false;
            if (name != null && (split = name.split("_")).length != 0 && split[0].endsWith("DUnitTest")) {
                isDUnitTest = true;
            }
            return isDUnitTest;
        }

        public String getLogFilePath() {
            return this.logFilePath;
        }

        private String getFileNamePrefix() {
            String timeStamp = new Time(System.currentTimeMillis()).toString();
            timeStamp = timeStamp.replace(':', '_');
            return this.fileNamePrefix + "-" + timeStamp;
        }

        public String getHistoryFileName() {
            if (this.generatedHistoryFileName == null) {
                String fileName;
                this.generatedHistoryFileName = fileName = new File(this.parentDir, this.getFileNamePrefix() + "-gfsh.history").getAbsolutePath();
                return fileName;
            }
            return this.generatedHistoryFileName;
        }

        public boolean isTestConfig() {
            return true;
        }

        public Level getLogLevel() {
            return Level.FINE;
        }
    }

    public static class HeadlessGfshShell
    extends Gfsh {
        private final ResultHandler handler;
        private final Lock lock = new ReentrantLock();
        private final Condition endOfShell = this.lock.newCondition();
        private ByteArrayOutputStream output = null;
        private String errorString = null;
        private boolean hasError = false;
        boolean stopCalledThroughAPI = false;

        protected HeadlessGfshShell(String testName, ResultHandler handler, HeadlessGfshConfig config) throws IOException {
            super(false, new String[0], (GfshConfig)config);
            this.handler = handler;
        }

        protected void handleExecutionResult(Object result) {
            String outputToPass;
            if (this.output == null) {
                this.output = new ByteArrayOutputStream(10240);
            }
            if (result != null && !result.equals(HeadlessGfsh.ERROR_RESULT)) {
                super.handleExecutionResult(result);
            }
            String capturedOutput = this.output.toString();
            this.output.reset();
            String string = outputToPass = HeadlessGfsh.ERROR_RESULT.equals(result) && this.errorString != null ? this.errorString : capturedOutput;
            if (result == null || HeadlessGfsh.ERROR_RESULT.equals(result)) {
                this.handler.handleExecutionResult((Object)HeadlessGfsh.ERROR_RESULT, outputToPass);
                this.errorString = null;
            } else {
                this.handler.handleExecutionResult(result, capturedOutput);
            }
        }

        int getCommandExecutionStatus() {
            return this.getLastExecutionStatus();
        }

        public void terminate() {
            this.stopPromptLoop();
            this.stop();
        }

        public void stop() {
            super.stop();
            this.stopCalledThroughAPI = true;
        }

        private void stopPromptLoop() {
            this.lock.lock();
            try {
                this.endOfShell.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public String getErrorString() {
            return this.errorString;
        }

        public boolean hasError() {
            return this.hasError;
        }

        public void promptLoop() {
            this.lock.lock();
            try {
                try {
                    this.endOfShell.await();
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private static void setGfshOutErr(PrintStream outToUse) {
            Gfsh.gfshout = outToUse;
            Gfsh.gfsherr = outToUse;
        }

        public void logWarning(String message, Throwable t) {
            super.logWarning(message, t);
            if (t != null) {
                String exceptionMessage = t.getMessage() != null ? t.getMessage() : "";
                this.errorString = t.getClass().getName() + ": " + exceptionMessage;
            } else {
                this.errorString = message;
            }
            this.hasError = true;
            this.handleExecutionResult(HeadlessGfsh.ERROR_RESULT);
        }

        public void logSevere(String message, Throwable t) {
            t.printStackTrace();
            super.logSevere(message, t);
            if (t != null) {
                String exceptionMessage = t.getMessage() != null ? t.getMessage() : "";
                this.errorString = t.getClass().getName() + ": " + exceptionMessage;
            } else {
                this.errorString = message;
            }
            this.hasError = true;
            this.handleExecutionResult(HeadlessGfsh.ERROR_RESULT);
        }

        protected LineReader createConsoleReader() {
            try {
                this.output = new ByteArrayOutputStream(10240);
                PrintStream sysout = new PrintStream(this.output);
                HeadlessGfshShell.setGfshOutErr(sysout);
                Terminal terminal = TerminalBuilder.builder().streams((InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)sysout).build();
                return LineReaderBuilder.builder().terminal(terminal).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

