/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionReinitializedException;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.cache30.TestCacheListener;
import org.apache.geode.cache30.TestCacheLoader;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionIdleExpiryTask;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.Wait;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public abstract class RegionTestCase
extends JUnit4CacheTestCase {
    private static final String WAIT_PROPERTY = "UpdatePropagationDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 60000;
    private static final int SLOP = 1000;
    private final AtomicInteger eventCount = new AtomicInteger();
    public static Region<Object, Object> preSnapshotRegion = null;
    private static final int MAX_KEYS = 10;

    @Override
    public final void postTearDownCacheTestCase() throws Exception {
        this.postTearDownRegionTestCase();
    }

    protected void postTearDownRegionTestCase() throws Exception {
    }

    protected <K, V> Region<K, V> createRegion(String name) throws CacheException {
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        return this.createRegion(name, regionFactory);
    }

    protected <K, V> Region<K, V> createRootRegion() throws CacheException {
        return this.createRootRegion(this.getRegionAttributes());
    }

    protected abstract <K, V> RegionAttributes<K, V> getRegionAttributes();

    protected void pauseIfNecessary() {
    }

    protected void pauseIfNecessary(int ms) {
    }

    protected void flushIfNecessary(Region r) {
    }

    @Test
    public void testContainsKey() throws CacheException {
        String key = this.getUniqueName();
        Region region = this.createRegion(key);
        Integer value = 42;
        Assert.assertFalse((boolean)region.containsKey((Object)key));
        region.create((Object)key, null);
        Assert.assertFalse((boolean)region.containsValueForKey((Object)key));
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)entry.getKey(), (Object)key);
        Assert.assertNull((Object)entry.getValue());
        region.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)region.containsValueForKey((Object)key));
        Assert.assertEquals((Object)entry, (Object)region.getEntry((Object)key));
        if (entry.isLocal()) {
            Assert.assertEquals((Object)value, (Object)entry.getValue());
        } else {
            Assert.assertEquals((Object)value, (Object)region.getEntry((Object)key).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadRegionAccess() throws CacheException {
        String key = this.getUniqueName();
        Region region = this.createRegion(key);
        Assert.assertNull((Object)region.get((Object)key));
        Assert.assertNull((Object)region.getEntry((Object)key));
        Integer value = 42;
        region.create((Object)key, (Object)value);
        try {
            logger.info("<ExpectedException action=add>org.apache.geode.cache.EntryExistsException</ExpectedException>");
            region.create((Object)key, (Object)value);
            Assert.fail((String)"Should have thrown an EntryExistsException");
        }
        catch (EntryExistsException entryExistsException) {
        }
        finally {
            logger.info("<ExpectedException action=remove>org.apache.geode.cache.EntryExistsException</ExpectedException>");
        }
    }

    @Test
    public void testPutNonExistentEntry() throws CacheException {
        String key = this.getUniqueName();
        Region region = this.createRegion(key);
        Assert.assertNull((Object)region.getEntry((Object)key));
        Integer value = 42;
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)key, (Object)entry.getKey());
        Assert.assertEquals((Object)value, (Object)entry.getValue());
        Assert.assertEquals((Object)value, (Object)region.get((Object)key));
        try {
            Collection values = region.values();
            Assert.assertEquals((long)1L, (long)values.size());
            Assert.assertEquals((Object)value, values.iterator().next());
        }
        catch (UnsupportedOperationException uoe) {
            logger.info("Region.values() reported UnsupportedOperation");
        }
    }

    protected boolean supportsSubregions() {
        return true;
    }

    protected boolean supportsLocalDestroyAndLocalInvalidate() {
        return true;
    }

    @Test
    public void testNulls() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String key = this.getUniqueName();
        Region region = this.createRegion(key);
        try {
            region.getSubregion(null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion(null, region.getAttributes());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion("TEST", null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"/", (Object)"/");
        Assert.assertEquals((long)47L, (long)47L);
        try {
            region.createSubregion("BAD/TEST", region.getAttributes());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion("", region.getAttributes());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.getEntry(null);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.get(null);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.get(null, null);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.put(null, (Object)42);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.put((Object)key, null);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.destroy(null);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSubRegions() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        RegionAttributes attrs = this.getRegionAttributes();
        RegionFactory regionFactory = this.getCache().createRegionFactory(attrs);
        regionFactory.setStatisticsEnabled(true);
        Region region = this.createRegion(name, regionFactory);
        attrs = region.getAttributes();
        CacheStatistics stats = region.getStatistics();
        long lastAccessed = stats.getLastAccessedTime();
        long lastModified = stats.getLastModifiedTime();
        try {
            region.createSubregion(name + "/BAD", attrs);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            CacheStatistics stats2 = region.getStatistics();
            Assert.assertEquals((long)lastAccessed, (long)stats2.getLastAccessedTime());
            Assert.assertEquals((long)lastModified, (long)stats2.getLastModifiedTime());
        }
        Region subregion = region.createSubregion(name, attrs);
        Assert.assertTrue((attrs != subregion.getAttributes() ? 1 : 0) != 0);
        Set subregions = region.subregions(false);
        Assert.assertEquals((long)1L, (long)subregions.size());
        Assert.assertEquals((Object)subregion, subregions.iterator().next());
    }

    public static boolean entryIsLocal(Region.Entry re) {
        if (re instanceof EntrySnapshot) {
            return ((EntrySnapshot)re).wasInitiallyLocal();
        }
        return re.isLocal();
    }

    @Test
    public void testDestroyEntry() throws CacheException {
        String key = this.getUniqueName();
        Integer value = 42;
        Region region = this.createRegion(key);
        try {
            region.destroy((Object)key);
            Assert.fail((String)"Should have thrown an EntryNotFoundException");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        region.destroy((Object)key);
        Region.Entry entry2 = region.getEntry((Object)key);
        logger.info("Found entry for destroyed key: " + String.valueOf(entry2));
        Assert.assertNull((Object)entry2);
        if (entry.isLocal()) {
            Assert.assertTrue((boolean)entry.isDestroyed());
        } else {
            Assert.assertFalse((boolean)entry.isDestroyed());
        }
        Assert.assertEquals((long)0L, (long)region.keySet().size());
        if (entry.isLocal()) {
            try {
                entry.getKey();
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getRegion();
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getStatistics();
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getUserAttribute();
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.setUserAttribute((Object)"blah");
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getValue();
                Assert.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDestroyRegion() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        region.createSubregion("SUB", region.getAttributes());
        region.destroyRegion();
        Assert.assertTrue((boolean)entry.isDestroyed());
        Assert.assertTrue((boolean)region.isDestroyed());
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsValueForKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value, (Object)"BLAH");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.createSubregion("SUB", this.getRegionAttributes());
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key, (Object)"BLAH");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion((Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.entrySet(false);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key, (Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getAttributes();
        try {
            region.getAttributesMutator();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getCache();
        }
        catch (RegionDestroyedException ex) {
            Assert.fail((String)"getCache() shouldn't have thrown a RegionDestroyedException");
        }
        try {
            region.getEntry((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getDistributedLock((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)name, (Object)region.getName());
        region.getParentRegion();
        Assert.assertEquals((Object)("/root/" + name), (Object)region.getFullPath());
        Assert.assertEquals((Object)name, (Object)region.getName());
        try {
            region.getRegionDistributedLock();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getStatistics();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getSubregion("SUB");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getUserAttribute();
        try {
            region.invalidate((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.invalidateRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.keySet();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroy((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroyRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidate((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidateRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value, (Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.setUserAttribute((Object)"ATTR");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.subregions(true);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.values();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Test
    public void testEntries() throws CacheException {
        int i;
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertEquals((long)0L, (long)region.entrySet(true).size());
        Assert.assertEquals((long)0L, (long)region.entrySet(false).size());
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Set entries = region.entrySet(false);
        Assert.assertEquals((long)3L, (long)entries.size());
        HashSet<String> keys = new HashSet<String>(Arrays.asList("A", "B", "C"));
        Iterator iter = entries.iterator();
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertTrue((boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
        entries = region.entrySet(true);
        Assert.assertEquals((long)3L, (long)entries.size());
        keys = new HashSet<String>(Arrays.asList("A", "B", "C"));
        iter = entries.iterator();
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertTrue((boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Iterator iter2 = region.entrySet(false).iterator();
        Region.Entry entry = (Region.Entry)iter2.next();
        region.destroy(entry.getKey());
        if (entry.isLocal()) {
            Assert.assertTrue((boolean)entry.isDestroyed());
        } else {
            Assert.assertFalse((boolean)entry.isDestroyed());
        }
    }

    @Test
    public void testEntriesRecursive() throws CacheException {
        int i;
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Region sub = region.createSubregion("SUB", region.getAttributes());
        sub.put((Object)"D", (Object)"d");
        sub.put((Object)"E", (Object)"e");
        sub.put((Object)"F", (Object)"f");
        Set entries = region.entrySet(true);
        Assert.assertEquals((long)6L, (long)entries.size());
        HashSet<String> keys = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Iterator iter = entries.iterator();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((String)("!hasNext, i=" + i), (boolean)iter.hasNext());
            Assert.assertTrue((String)("remove returned false, i=" + i), (boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
        entries = region.entrySet(true);
        Assert.assertEquals((long)6L, (long)entries.size());
        keys = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        iter = entries.iterator();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((String)("!hasNext, i=" + i), (boolean)iter.hasNext());
            Assert.assertTrue((String)("remove returned false, i=" + i), (boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Iterator iter2 = region.entrySet(true).iterator();
        Region.Entry entry = (Region.Entry)iter2.next();
        String key = (String)entry.getKey();
        region.destroy((Object)key);
        Assert.assertFalse((boolean)region.containsKey((Object)key));
        Assert.assertTrue((boolean)entry.isDestroyed());
    }

    @Test
    public void testGetCache() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertSame((Object)this.getCache(), (Object)region.getCache());
    }

    @Test
    public void testGetName() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertEquals((Object)name, (Object)region.getName());
        Assert.assertEquals((Object)"root", (Object)region.getParentRegion().getName());
    }

    @Test
    public void testGetPathFromRoot() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String fullPath = "/root/" + name;
        Assert.assertEquals((Object)fullPath, (Object)region.getFullPath());
        Assert.assertEquals((Object)"/root", (Object)region.getParentRegion().getFullPath());
        RegionFactory regionFactory = cache.createRegionFactory(region.getAttributes());
        Region sub = regionFactory.createSubregion(region, "SUB");
        Assert.assertEquals((Object)(fullPath + "/SUB"), (Object)sub.getFullPath());
    }

    @Test
    public void testGetParentRegion() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertEquals(this.getRootRegion(), (Object)region.getParentRegion());
        RegionFactory regionFactory = cache.createRegionFactory(region.getAttributes());
        Region sub = regionFactory.createSubregion(region, "SUB");
        Assert.assertEquals(region, (Object)sub.getParentRegion());
        Assert.assertSame((Object)sub, (Object)region.getSubregion("SUB"));
        Assert.assertNotNull((Object)sub.getAttributes());
    }

    @Test
    public void testRegionUserAttribute() throws CacheException {
        String name = this.getUniqueName();
        String value = "USER_ATTRIBUTE";
        Region region = this.createRegion(name);
        Assert.assertNull((Object)region.getUserAttribute());
        region.setUserAttribute((Object)value);
        Assert.assertEquals((Object)value, (Object)region.getUserAttribute());
    }

    @Test
    public void testEntryUserAttribute() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String attr = "USER_ATTRIBUTE";
        Region region = this.createRegion(name);
        region.create((Object)key, null);
        Region.Entry entry = region.getEntry((Object)key);
        entry.setUserAttribute((Object)attr);
        Assert.assertEquals((Object)attr, (Object)entry.getUserAttribute());
        entry = region.getEntry((Object)key);
        Assert.assertEquals((Object)attr, (Object)entry.getUserAttribute());
    }

    @Test
    public void testInvalidateEntry() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        long beforeInvalidates = this.getCache().getCachePerfStats().getInvalidates();
        Region.Entry entry = region.getEntry((Object)key);
        region.invalidate((Object)key);
        if (entry.isLocal()) {
            Assert.assertNull((Object)entry.getValue());
        }
        Assert.assertNull((Object)region.get((Object)key));
        long afterInvalidates = this.getCache().getCachePerfStats().getInvalidates();
        Assert.assertEquals((String)"Invalidate CachePerfStats incorrect", (long)(beforeInvalidates + 1L), (long)afterInvalidates);
    }

    @Test
    public void testInvalidateRegion() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        for (int i = 0; i < 50; ++i) {
            region.put((Object)("Key=" + i), (Object)("Value-" + i));
        }
        region.invalidateRegion();
        Region.Entry entry = region.getEntry((Object)"A");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"B");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"C");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        for (int i = 0; i < 50; ++i) {
            String key = "Key=" + i;
            Assert.assertFalse((String)("containsValueForKey returned true for key " + key), (boolean)region.containsValueForKey((Object)key));
            Assert.assertTrue((String)("containsKey returned false for key " + key), (boolean)region.containsKey((Object)key));
        }
    }

    @Test
    public void testKeys() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertEquals((long)0L, (long)region.keySet().size());
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Set keys = region.keySet();
        Assert.assertEquals((long)3L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("A"));
        Assert.assertTrue((boolean)keys.contains("B"));
        Assert.assertTrue((boolean)keys.contains("C"));
    }

    @Test
    public void testLocalDestroyEntry() throws CacheException {
        if (!this.supportsLocalDestroyAndLocalInvalidate()) {
            return;
        }
        String key = this.getUniqueName();
        Integer value = 42;
        Region region = this.createRegion(key);
        boolean isMirrored = this.getRegionAttributes().getMirrorType().isMirrored();
        try {
            region.localDestroy((Object)key);
            if (isMirrored) {
                Assert.fail((String)"Should have thrown an IllegalStateException");
            }
            Assert.fail((String)"Should have thrown an EntryNotFoundException");
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        catch (IllegalStateException ex) {
            if (!isMirrored) {
                throw ex;
            }
            return;
        }
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        region.localDestroy((Object)key);
        Assert.assertNull((Object)region.getEntry((Object)key));
        Assert.assertTrue((boolean)entry.isDestroyed());
        Assert.assertEquals((long)0L, (long)region.keySet().size());
        try {
            entry.getKey();
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getRegion();
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getStatistics();
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getUserAttribute();
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.setUserAttribute((Object)"blah");
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getValue();
            Assert.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalDestroyRegion() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        Assert.assertNotNull((Object)entry);
        region.createSubregion("SUB", region.getAttributes());
        region.localDestroyRegion();
        Assert.assertTrue((boolean)entry.isDestroyed());
        Assert.assertTrue((boolean)region.isDestroyed());
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsValueForKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value, (Object)"BLAH");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.createSubregion("SUB", this.getRegionAttributes());
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key, (Object)"BLAH");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion((Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.entrySet(false);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key, (Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getAttributes();
        try {
            region.getAttributesMutator();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getCache();
        }
        catch (RegionDestroyedException ex) {
            Assert.fail((String)"getCache() shouldn't have thrown a RegionDestroyedException");
        }
        try {
            region.getEntry((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getDistributedLock((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)name, (Object)region.getName());
        region.getParentRegion();
        Assert.assertEquals((Object)("/root/" + name), (Object)region.getFullPath());
        try {
            region.getRegionDistributedLock();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getStatistics();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getSubregion("SUB");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getUserAttribute();
        try {
            region.invalidate((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.invalidateRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.keySet();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroy((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroyRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidate((Object)key);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidateRegion();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value, (Object)"ARG");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.setUserAttribute((Object)"ATTR");
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.subregions(true);
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.values();
            Assert.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseRegion() throws CacheException {
        String name = this.getUniqueName();
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        TestCacheListener<Object, Object> list = new TestCacheListener<Object, Object>(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }

            @Override
            public void afterRegionDestroy2(RegionEvent re) {
                Assert.assertEquals((Object)Operation.REGION_CLOSE, (Object)re.getOperation());
            }

            @Override
            public void close2() {
            }
        };
        regionFactory.addCacheListener((CacheListener)list);
        Region region = this.createRegion(name, regionFactory);
        File diskDir = null;
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            diskDir = this.getCache().findDiskStore(this.getRegionAttributes().getDiskStoreName()).getDiskDirs()[0];
            this.getCache().getLogger().info("list=" + Arrays.toString(diskDir.list()));
        }
        for (int i = 0; i < 1000; ++i) {
            region.put((Object)i, (Object)String.valueOf(i));
        }
        Assert.assertTrue((boolean)list.wasInvoked());
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            Assert.assertTrue((diskDir.list().length > 0 ? 1 : 0) != 0);
        }
        region.getAttributes().getDataPolicy().withPersistence();
        region.close();
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            Assert.assertTrue((diskDir.list().length > 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)list.waitForInvocation(333));
        Assert.assertTrue((boolean)list.isClosed());
        Assert.assertTrue((boolean)region.isDestroyed());
        RegionFactory regionFactory2 = this.getCache().createRegionFactory(this.getRegionAttributes());
        region = this.createRegion(name, regionFactory2);
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            for (int i = 0; i < 1000; ++i) {
                Region.Entry entry = region.getEntry((Object)i);
                Assert.assertNotNull((String)("entry " + i + " not found"), (Object)entry);
                Assert.assertEquals((Object)String.valueOf(i), (Object)entry.getValue());
            }
            Assert.assertEquals((long)1000L, (long)region.keySet().size());
        } else {
            Assert.assertEquals((long)0L, (long)region.keySet().size());
        }
        region.localDestroyRegion();
    }

    @Test
    public void testLocalInvalidateEntry() throws CacheException {
        if (!this.supportsLocalDestroyAndLocalInvalidate()) {
            return;
        }
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        boolean isMirrorKeysValues = this.getRegionAttributes().getMirrorType().isKeysValues();
        try {
            region.localInvalidate((Object)key);
            if (isMirrorKeysValues) {
                Assert.fail((String)"Should have thrown an IllegalStateException");
            }
        }
        catch (IllegalStateException e) {
            if (!isMirrorKeysValues) {
                throw e;
            }
            return;
        }
        Assert.assertNull((Object)entry.getValue());
        Assert.assertNull((Object)region.get((Object)key));
    }

    @Test
    public void testLocalInvalidateRegion() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        boolean isKV = this.getRegionAttributes().getMirrorType().isKeysValues();
        try {
            region.localInvalidateRegion();
            if (isKV) {
                Assert.fail((String)"Should have thrown an IllegalStateException");
            }
        }
        catch (IllegalStateException e) {
            if (!isKV) {
                throw e;
            }
            return;
        }
        Region.Entry entry = region.getEntry((Object)"A");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"B");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"C");
        Assert.assertNotNull((Object)entry);
        Assert.assertNull((Object)entry.getValue());
    }

    @Test
    public void testSubregions() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Assert.assertEquals((long)0L, (long)region.subregions(false).size());
        region.createSubregion("A", region.getAttributes());
        region.createSubregion("B", region.getAttributes());
        region.createSubregion("C", region.getAttributes());
        Set subregions = region.subregions(false);
        Assert.assertEquals((long)3L, (long)subregions.size());
        HashSet<String> names = new HashSet<String>(Arrays.asList("A", "B", "C"));
        Iterator iter = subregions.iterator();
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertTrue((boolean)names.remove(((Region)iter.next()).getName()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testSubRegionsRecursive() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionFactory regionFactory = this.getCache().createRegionFactory(region.getAttributes());
        Region A = regionFactory.createSubregion(region, "A");
        Region B = regionFactory.createSubregion(region, "B");
        Region C = regionFactory.createSubregion(region, "C");
        regionFactory.createSubregion(A, "D");
        regionFactory.createSubregion(B, "E");
        regionFactory.createSubregion(C, "F");
        Set subRegions = region.subregions(true);
        Assert.assertEquals((long)6L, (long)subRegions.size());
        HashSet<String> names = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Iterator iter = subRegions.iterator();
        for (int i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertTrue((boolean)names.remove(((Region)iter.next()).getName()));
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testValues() throws CacheException {
        String name = this.getUniqueName();
        LogService.getLogger().info("testValues region name is " + name);
        Region region = this.createRegion(name);
        Assert.assertEquals((long)0L, (long)region.values().size());
        region.create((Object)"A", null);
        TreeSet values = new TreeSet(region.values());
        Assert.assertTrue((boolean)values.isEmpty());
        Iterator itr = values.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        try {
            itr.next();
            Assert.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        values = new TreeSet(region.values());
        Assert.assertEquals((long)3L, (long)values.size());
        Iterator iter = values.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"a", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"b", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"c", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        region.invalidate((Object)"B");
        values = new TreeSet(region.values());
        Assert.assertEquals((long)2L, (long)values.size());
        iter = values.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"a", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"c", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private Object fetchEntryValue(Region.Entry re) {
        Object key;
        if (re.isLocal()) {
            return re.getValue();
        }
        Region r = re.getRegion();
        Region.Entry freshRE = r.getEntry(key = re.getKey());
        if (freshRE == null) {
            return null;
        }
        return freshRE.getValue();
    }

    private void waitForInvalidate(Region.Entry entry, long p_tilt) {
        this.waitForInvalidate(entry, p_tilt, 100);
    }

    private void waitForInvalidate(Region.Entry entry, long p_tilt, int pauseMs) {
        long tilt = p_tilt;
        if (entry == null) {
            return;
        }
        while (true) {
            boolean wasInvalidated = this.fetchEntryValue(entry) == null;
            long now = System.currentTimeMillis();
            if (now >= tilt) break;
            if (!wasInvalidated) {
                Wait.pause(pauseMs);
                continue;
            }
            if (now >= tilt - 1000L) {
                logger.warn("Entry invalidated sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            Assert.fail((String)("Entry invalidated prematurely now=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (this.fetchEntryValue(entry) != null) {
            if (System.currentTimeMillis() > tilt) {
                if (this.fetchEntryValue(entry) == null) break;
                Assert.fail((String)"Entry failed to invalidate");
            }
            Wait.pause(pauseMs);
        }
    }

    private boolean isEntryDestroyed(Region.Entry re) {
        Object key;
        if (re.isLocal()) {
            return re.isDestroyed();
        }
        Region r = re.getRegion();
        Region.Entry freshRE = r.getEntry(key = re.getKey());
        if (freshRE == null) {
            return true;
        }
        return freshRE.isDestroyed();
    }

    private void waitForDestroy(Region.Entry entry, long p_tilt) {
        this.waitForDestroy(entry, p_tilt, 100);
    }

    private void waitForDestroy(Region.Entry entry, long p_tilt, int pauseMs) {
        long now;
        long tilt = p_tilt;
        while ((now = System.currentTimeMillis()) < tilt) {
            if (!this.isEntryDestroyed(entry)) {
                Wait.pause(pauseMs);
                continue;
            }
            if (now >= tilt - 1000L) {
                logger.warn("Entry destroyed sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            Assert.fail((String)("Entry destroyed prematurelynow=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (!this.isEntryDestroyed(entry)) {
            org.apache.geode.internal.Assert.assertTrue((System.currentTimeMillis() <= tilt ? 1 : 0) != 0, (Object)"Entry failed to destroy");
            Wait.pause(pauseMs);
        }
    }

    private void waitForRegionDestroy(Region<Object, Object> region, long p_tilt) {
        long now;
        long tilt = p_tilt;
        while ((now = System.currentTimeMillis()) < tilt) {
            if (!region.isDestroyed()) {
                Wait.pause(10);
                continue;
            }
            if (now >= tilt - 1000L) {
                logger.warn("Region destroyed sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            Assert.fail((String)("Region destroyed prematurelynow=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (!region.isDestroyed()) {
            org.apache.geode.internal.Assert.assertTrue((System.currentTimeMillis() <= tilt ? 1 : 0) != 0, (Object)"Region failed to destroy");
            Wait.pause(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryTtlInvalidate() throws CacheException {
        Region.Entry entry;
        long tilt;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        regionFactory.setEntryTimeToLive(expire);
        regionFactory.setStatisticsEnabled(true);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, regionFactory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryTtl1() {
        Region.Entry entry;
        long tilt;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        regionFactory.setCustomEntryTimeToLive(new TestExpiry("KEY2", expire));
        regionFactory.setStatisticsEnabled(true);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, regionFactory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.put((Object)"KEY1", (Object)"VALUE");
        GeodeAwaitility.await().atLeast(40L, TimeUnit.MILLISECONDS).until(() -> region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        assert (region.get((Object)"KEY1").equals("VALUE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryTtl2() {
        Region.Entry entry;
        long tilt;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire2 = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        regionFactory.setCustomEntryTimeToLive(new TestExpiry("KEY2", expire2));
        regionFactory.setStatisticsEnabled(true);
        TestCacheListenerCustom list = new TestCacheListenerCustom();
        regionFactory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, regionFactory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE");
        Wait.pause(40);
        Assert.assertEquals((Object)region.get((Object)"KEY1"), (Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.create((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            Assert.assertTrue((boolean)list.waitForInvocation(5000));
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY1"), (Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY1"), (Object)"VALUE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryTtl3() {
        String name = this.getUniqueName();
        int timeout1 = 20;
        int timeout2 = 40;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        RegionFactory regionFactory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        regionFactory.setCustomEntryTimeToLive(new TestExpiry("KEY1", expire1));
        regionFactory.setStatisticsEnabled(true);
        TestCacheListenerEventCount list = new TestCacheListenerEventCount();
        this.eventCount.set(0);
        regionFactory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt2;
            Region.Entry entry;
            long tilt1;
            Region region = this.createRegion(name, regionFactory);
            ExpiryTask.suspendExpiration();
            this.eventCount.set(0);
            try {
                region.create((Object)"KEY1", (Object)"VALUE1");
                tilt1 = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)list.waitForInvocation(1000));
                org.apache.geode.internal.Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt1, 10);
            GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
            this.eventCount.set(0);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE1");
                tilt1 = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY1");
                org.apache.geode.internal.Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
                Assert.assertTrue((boolean)list.waitForInvocation(10000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt1, 10);
            GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
            this.eventCount.set(0);
            String key2 = "KEY2";
            AttributesMutator mutt = region.getAttributesMutator();
            ExpirationAttributes expire2 = new ExpirationAttributes(40, ExpirationAction.INVALIDATE);
            mutt.setCustomEntryTimeToLive(new TestExpiry("KEY2", expire2));
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE1");
                region.put((Object)"KEY2", (Object)"VALUE2");
                tilt1 = System.currentTimeMillis() + 20L;
                tilt2 = tilt1 + 40L - 20L;
                entry = region.getEntry((Object)"KEY1");
                org.apache.geode.internal.Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
                entry = region.getEntry((Object)"KEY2");
                org.apache.geode.internal.Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
                Assert.assertTrue((boolean)list.waitForInvocation(1000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt2, 20);
            GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
            this.eventCount.set(0);
            entry = region.getEntry((Object)"KEY1");
            org.apache.geode.internal.Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            ExpirationAttributes expire3 = new ExpirationAttributes(20, ExpirationAction.DESTROY);
            mutt.setCustomEntryTimeToLive(new TestExpiry("KEY1", expire3));
            this.waitForDestroy(entry, tilt1, 10);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryTtl3() {
        LocalRegion region;
        String name = this.getUniqueName();
        int timeout1 = 500000;
        int timeout2 = 2000000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire1);
        factory.setStatisticsEnabled(true);
        TestCacheListenerEventCount list = new TestCacheListenerEventCount();
        this.eventCount.set(0);
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = (LocalRegion)this.createRegion(name, factory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE1");
        EntryExpiryTask eet = region.getEntryExpiryTask((Object)"KEY1");
        long firstExpiryTime = eet.getExpirationTime();
        AttributesMutator mutt = region.getAttributesMutator();
        ExpirationAttributes expire2 = new ExpirationAttributes(2000000, ExpirationAction.INVALIDATE);
        mutt.setEntryTimeToLive(expire2);
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long secondExpiryTime = eet.getExpirationTime();
        if (secondExpiryTime - firstExpiryTime <= 0L) {
            Assert.fail((String)("expiration time should have been greater after changing region config from 500 to 2000. firstExpiryTime=" + firstExpiryTime + " secondExpiryTime=" + secondExpiryTime));
        }
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire3 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        mutt.setEntryTimeToLive(expire3);
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long thirdExpiryTime = eet.getExpirationTime();
        Assert.assertEquals((long)firstExpiryTime, (long)thirdExpiryTime);
        Assert.assertEquals((long)0L, (long)this.eventCount.get());
        Wait.waitForExpiryClockToChange(region);
        Region.Entry entry = region.getEntry((Object)"KEY1");
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire4 = new ExpirationAttributes(1, ExpirationAction.INVALIDATE);
        mutt.setEntryTimeToLive(expire4);
        GeodeAwaitility.await().alias("entry never became invalid").until(() -> this.fetchEntryValue(entry) == null);
        GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
        this.eventCount.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryFromLoadTtlInvalidate() throws CacheException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        factory.setCacheLoader((CacheLoader)new TestCacheLoader<Object, Object>(){

            @Override
            public Object load2(LoaderHelper helper) {
                return "VALUE";
            }
        });
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            Region.Entry entry;
            long tilt;
            Region region = this.createRegion(name, factory);
            ExpiryTask.suspendExpiration();
            try {
                region.get((Object)"KEY");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryTtlDestroy() throws CacheException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.DESTROY);
        factory.setEntryTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            Region.Entry entry;
            long tilt;
            Region region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis();
                entry = region.getEntry((Object)"KEY");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    @Test
    public void testRegionTtlInvalidate() throws CacheException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        VM vm0 = VM.getVM(0);
        final String name = this.getUniqueName();
        vm0.invoke("testRegionTtlInvalidate", new CacheSerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region.Entry entry;
                long tilt;
                Region region;
                int timeout = 22;
                String key = "KEY";
                String value = "VALUE";
                RegionFactory factory = RegionTestCase.this.getCache().createRegionFactory(RegionTestCase.this.getRegionAttributes());
                ExpirationAttributes expire = new ExpirationAttributes(22, ExpirationAction.INVALIDATE);
                factory.setRegionTimeToLive(expire);
                factory.setStatisticsEnabled(true);
                ExpiryTask.suspendExpiration();
                try {
                    System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                    try {
                        region = RegionTestCase.this.createRegion(name, factory);
                        region.put((Object)key, (Object)value);
                        region.put((Object)"k2", (Object)"v2");
                        tilt = System.currentTimeMillis() + 22L;
                        entry = region.getEntry((Object)key);
                        Assert.assertNotNull((Object)entry.getValue());
                    }
                    finally {
                        System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                    }
                }
                finally {
                    ExpiryTask.permitExpiration();
                }
                RegionTestCase.this.waitForInvalidate(entry, tilt, 10);
                RegionTestCase.this.waitForInvalidate(region.getEntry((Object)"k2"), tilt, 10);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionTtlDestroy() throws CacheException {
        long tilt;
        Region region;
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        String name = this.getUniqueName();
        int timeout = 22;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(22, ExpirationAction.DESTROY);
        factory.setRegionTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        ExpiryTask.suspendExpiration();
        try {
            try {
                region = this.createRegion(name, factory);
                Assert.assertFalse((boolean)region.isDestroyed());
                tilt = System.currentTimeMillis() + 22L;
                region.put((Object)key, (Object)value);
                Region.Entry entry = region.getEntry((Object)key);
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForRegionDestroy(region, tilt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryIdleInvalidate() throws CacheException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        TestCacheListenerCustom list = new TestCacheListenerCustom();
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            Region.Entry entry;
            long tilt;
            Region region = this.createRegion(name, factory);
            ExpiryTask.suspendExpiration();
            try {
                region.create((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                Assert.assertTrue((boolean)list.waitForInvocation(333));
                entry = region.getEntry((Object)"KEY");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryIdleTimeout1() {
        Region.Entry entry;
        long tilt;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout(new TestExpiry("KEY2", expire));
        factory.setStatisticsEnabled(true);
        TestCacheListenerCustom list = new TestCacheListenerCustom();
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, factory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE");
        Wait.pause(40);
        Assertions.assertThat((Object)region.get((Object)"KEY1")).isEqualTo((Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.create((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            Assert.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY2");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY1"), (Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY1"), (Object)"VALUE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryIdleTimeout2() {
        Region.Entry entry;
        long tilt;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire);
        ExpirationAttributes expire2 = new ExpirationAttributes(0, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout(new TestExpiry("KEY2", expire2));
        factory.setStatisticsEnabled(true);
        TestCacheListenerCustom list = new TestCacheListenerCustom();
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, factory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY2", (Object)"VALUE");
        Wait.pause(40);
        Assertions.assertThat((Object)region.get((Object)"KEY2")).isEqualTo((Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.create((Object)"KEY1", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            Assert.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY1");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY2"), (Object)"VALUE");
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY1");
            Assert.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        Assert.assertEquals((Object)region.get((Object)"KEY2"), (Object)"VALUE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryIdleTimeout3() {
        LocalRegion region;
        String name = this.getUniqueName();
        int timeout1 = 500000;
        int timeout2 = 2000000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout(new TestExpiry("KEY1", expire1));
        factory.setStatisticsEnabled(true);
        TestCacheListenerEventCount list = new TestCacheListenerEventCount();
        this.eventCount.set(0);
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = (LocalRegion)this.createRegion(name, factory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE1");
        EntryExpiryTask eet = region.getEntryExpiryTask((Object)"KEY1");
        long firstExpiryTime = eet.getExpirationTime();
        AttributesMutator mutt = region.getAttributesMutator();
        ExpirationAttributes expire2 = new ExpirationAttributes(2000000, ExpirationAction.INVALIDATE);
        mutt.setCustomEntryIdleTimeout(new TestExpiry("KEY1", expire2));
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long secondExpiryTime = eet.getExpirationTime();
        if (secondExpiryTime - firstExpiryTime <= 0L) {
            Assert.fail((String)("expiration time should have been greater after changing region config from 500 to 2000. firstExpiryTime=" + firstExpiryTime + " secondExpiryTime=" + secondExpiryTime));
        }
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire3 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        mutt.setCustomEntryIdleTimeout(new TestExpiry("KEY1", expire3));
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long thirdExpiryTime = eet.getExpirationTime();
        Assert.assertEquals((long)firstExpiryTime, (long)thirdExpiryTime);
        Assert.assertEquals((long)0L, (long)this.eventCount.get());
        Wait.waitForExpiryClockToChange(region);
        Region.Entry entry = region.getEntry((Object)"KEY1");
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire4 = new ExpirationAttributes(1, ExpirationAction.INVALIDATE);
        mutt.setCustomEntryIdleTimeout(new TestExpiry("KEY1", expire4));
        GeodeAwaitility.await().alias("entry never became invalid").until(() -> this.fetchEntryValue(entry) == null);
        GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
        this.eventCount.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryIdleTimeout3() {
        LocalRegion region;
        String name = this.getUniqueName();
        int timeout1 = 500000;
        int timeout2 = 2000000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire1);
        factory.setStatisticsEnabled(true);
        TestCacheListenerEventCount list = new TestCacheListenerEventCount();
        this.eventCount.set(0);
        factory.setCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = (LocalRegion)this.createRegion(name, factory.create());
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE1");
        EntryExpiryTask eet = region.getEntryExpiryTask((Object)"KEY1");
        long firstExpiryTime = eet.getExpirationTime();
        AttributesMutator mutt = region.getAttributesMutator();
        ExpirationAttributes expire2 = new ExpirationAttributes(2000000, ExpirationAction.INVALIDATE);
        mutt.setEntryIdleTimeout(expire2);
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long secondExpiryTime = eet.getExpirationTime();
        if (secondExpiryTime - firstExpiryTime <= 0L) {
            Assert.fail((String)("expiration time should have been greater after changing region config from 500 to 2000. firstExpiryTime=" + firstExpiryTime + " secondExpiryTime=" + secondExpiryTime));
        }
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire3 = new ExpirationAttributes(500000, ExpirationAction.INVALIDATE);
        mutt.setEntryIdleTimeout(expire3);
        eet = region.getEntryExpiryTask((Object)"KEY1");
        long thirdExpiryTime = eet.getExpirationTime();
        Assert.assertEquals((long)firstExpiryTime, (long)thirdExpiryTime);
        Assert.assertEquals((long)0L, (long)this.eventCount.get());
        Wait.waitForExpiryClockToChange(region);
        Region.Entry entry = region.getEntry((Object)"KEY1");
        mutt = region.getAttributesMutator();
        ExpirationAttributes expire4 = new ExpirationAttributes(1, ExpirationAction.INVALIDATE);
        mutt.setEntryIdleTimeout(expire4);
        GeodeAwaitility.await().alias("entry never became invalid").until(() -> this.fetchEntryValue(entry) == null);
        GeodeAwaitility.await().alias("eventCount never became 1").until(() -> this.eventCount.get() == 1);
        this.eventCount.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomIdleOnce() {
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryTimeToLive(new CountExpiry("KEY2", expire));
        factory.setStatisticsEnabled(true);
        Class<CountExpiry> clazz = CountExpiry.class;
        synchronized (CountExpiry.class) {
            Region.Entry entry;
            long tilt;
            CountExpiry.invokeCounts.clear();
            // ** MonitorExit[var8_8] (shouldn't be in output)
            Region region = null;
            System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
            try {
                region = this.createRegion(name, factory);
            }
            finally {
                if (region.getAttributes().getPartitionAttributes() == null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            region.put((Object)"KEY1", (Object)"VALUE");
            Wait.pause(40);
            assert (region.get((Object)"KEY1").equals("VALUE"));
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY2", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY2");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
                if (region.getAttributes().getPartitionAttributes() != null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            this.waitForInvalidate(entry, tilt);
            assert (region.get((Object)"KEY1").equals("VALUE"));
            Class<CountExpiry> clazz2 = CountExpiry.class;
            synchronized (CountExpiry.class) {
                if (CountExpiry.invokeCounts.size() != 2) {
                    Assert.fail((String)("CountExpiry not invoked correctly, size = " + CountExpiry.invokeCounts.size()));
                }
                Integer i = (Integer)CountExpiry.invokeCounts.get("KEY1");
                Assert.assertNotNull((Object)i);
                Assert.assertEquals((long)1L, (long)i.intValue());
                i = (Integer)CountExpiry.invokeCounts.get("KEY2");
                Assert.assertNotNull((Object)i);
                Assert.assertEquals((long)1L, (long)i.intValue());
                // ** MonitorExit[var12_14] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEntryIdleReset() {
        String name = this.getUniqueName();
        int timeout = 200000;
        String key1 = "KEY1";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(200000, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout(new TestExpiry("KEY1", expire));
        factory.setStatisticsEnabled(true);
        TestCacheListenerCustom list = new TestCacheListenerCustom();
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            LocalRegion region = (LocalRegion)this.createRegion(name, factory);
            ExpiryTask.suspendExpiration();
            try {
                region.create((Object)"KEY1", (Object)"VALUE");
                Assert.assertTrue((boolean)list.waitForInvocation(5000));
                Region.Entry entry = region.getEntry((Object)"KEY1");
                Assert.assertNotNull((Object)entry.getValue());
                EntryExpiryTask eet = region.getEntryExpiryTask((Object)"KEY1");
                long createExpiryTime = eet.getExpirationTime();
                Wait.waitForExpiryClockToChange(region);
                region.get((Object)"KEY1");
                Assert.assertSame((Object)eet, (Object)region.getEntryExpiryTask((Object)"KEY1"));
                long getExpiryTime = eet.getExpirationTime();
                if (getExpiryTime - createExpiryTime <= 0L) {
                    Assert.fail((String)("get did not reset the expiration time. createExpiryTime=" + createExpiryTime + " getExpiryTime=" + getExpiryTime));
                }
                Wait.waitForExpiryClockToChange(region);
                region.put((Object)"KEY1", (Object)"VALUE");
                Assert.assertSame((Object)eet, (Object)region.getEntryExpiryTask((Object)"KEY1"));
                long putExpiryTime = eet.getExpirationTime();
                if (putExpiryTime - getExpiryTime <= 0L) {
                    Assert.fail((String)("put did not reset the expiration time. getExpiryTime=" + getExpiryTime + " putExpiryTime=" + putExpiryTime));
                }
            }
            finally {
                ExpiryTask.permitExpiration();
            }
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryIdleDestroy() {
        EntryExpiryTask.expiryTaskListener = new ExpiryCallbacks();
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        TestCacheListener<Object, Object> list = new TestCacheListener<Object, Object>(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterDestroy2(EntryEvent e) {
            }
        };
        factory.addCacheListener((CacheListener)list);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            Region.Entry entry;
            long tilt;
            Region region = this.createRegion(name, factory);
            ExpiryTask.suspendExpiration();
            try {
                region.create((Object)"KEY", null);
                tilt = System.currentTimeMillis() + 20L;
                Assert.assertTrue((boolean)list.wasInvoked());
                entry = region.getEntry((Object)"KEY");
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
            Assert.assertNull((Object)region.getEntry((Object)"KEY"));
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                Assert.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            EntryExpiryTask.expiryTaskListener = null;
        }
    }

    @Test
    public void testEntryIdleReset() {
        String name = this.getUniqueName();
        int timeout = 90;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(90, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        LocalRegion region = (LocalRegion)this.createRegion(name, factory);
        region.create((Object)"KEY", null);
        EntryExpiryTask eet = region.getEntryExpiryTask((Object)"KEY");
        long createExpiryTime = eet.getExpirationTime();
        Wait.waitForExpiryClockToChange(region);
        region.get((Object)"KEY");
        Assert.assertSame((Object)eet, (Object)region.getEntryExpiryTask((Object)"KEY"));
        long getExpiryTime = eet.getExpirationTime();
        if (getExpiryTime - createExpiryTime <= 0L) {
            Assert.fail((String)("get did not reset the expiration time. createExpiryTime=" + createExpiryTime + " getExpiryTime=" + getExpiryTime));
        }
        Wait.waitForExpiryClockToChange(region);
        region.put((Object)"KEY", (Object)"VALUE");
        Assert.assertSame((Object)eet, (Object)region.getEntryExpiryTask((Object)"KEY"));
        long putExpiryTime = eet.getExpirationTime();
        if (putExpiryTime - getExpiryTime <= 0L) {
            Assert.fail((String)("put did not reset the expiration time. getExpiryTime=" + getExpiryTime + " putExpiryTime=" + putExpiryTime));
        }
        Wait.waitForExpiryClockToChange(region);
        region.invalidate((Object)"KEY");
        Assert.assertSame((Object)eet, (Object)region.getEntryExpiryTask((Object)"KEY"));
        long invalidateExpiryTime = eet.getExpirationTime();
        if (region.getConcurrencyChecksEnabled()) {
            if (putExpiryTime - getExpiryTime <= 0L) {
                Assert.fail((String)("invalidate did not reset the expiration time. putExpiryTime=" + putExpiryTime + " invalidateExpiryTime=" + invalidateExpiryTime));
            }
        } else if (invalidateExpiryTime != putExpiryTime) {
            Assert.fail((String)("invalidate did reset the expiration time. putExpiryTime=" + putExpiryTime + " invalidateExpiryTime=" + invalidateExpiryTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryExpirationAfterMutate() throws CacheException {
        Region.Entry entry;
        Region region;
        String name = this.getUniqueName();
        int timeout = 20;
        int hugeTimeout = Integer.MAX_VALUE;
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        ExpirationAttributes hugeExpire = new ExpirationAttributes(Integer.MAX_VALUE, ExpirationAction.INVALIDATE);
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        factory.setStatisticsEnabled(true);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, factory);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY", (Object)"VALUE");
        long tilt = System.currentTimeMillis() + 20L;
        ExpiryTask.suspendExpiration();
        try {
            region.getAttributesMutator().setEntryIdleTimeout(expire);
            entry = region.getEntry((Object)"KEY");
            Assert.assertEquals((Object)"VALUE", (Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        region.getAttributesMutator().setEntryIdleTimeout(hugeExpire);
        region.put((Object)"KEY", (Object)"VALUE");
        tilt = System.currentTimeMillis() + 20L;
        entry = region.getEntry((Object)"KEY");
        Wait.pause(40);
        Assert.assertEquals((Object)"VALUE", (Object)entry.getValue());
        region.getAttributesMutator().setEntryIdleTimeout(expire);
        this.waitForInvalidate(entry, tilt);
    }

    @Test
    public void testEntryIdleTtl() {
        String name = this.getUniqueName();
        int timeout = 2000;
        String key = "IDLE_TTL_KEY";
        String value = "IDLE_TTL_VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expireIdle = new ExpirationAttributes(1000, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expireIdle);
        ExpirationAttributes expireTtl = new ExpirationAttributes(2000, ExpirationAction.DESTROY);
        factory.setEntryTimeToLive(expireTtl);
        factory.setStatisticsEnabled(true);
        LocalRegion region = (LocalRegion)this.createRegion(name, factory);
        region.create((Object)"IDLE_TTL_KEY", (Object)"IDLE_TTL_VALUE");
        EntryExpiryTask eet = region.getEntryExpiryTask((Object)"IDLE_TTL_KEY");
        long firstIdleExpiryTime = eet.getIdleExpirationTime();
        long firstTTLExpiryTime = eet.getTTLExpirationTime();
        if (firstIdleExpiryTime - firstTTLExpiryTime >= 0L) {
            Assert.fail((String)("idle should be less than ttl: idle=" + firstIdleExpiryTime + " ttl=" + firstTTLExpiryTime));
        }
        Wait.waitForExpiryClockToChange(region);
        region.get((Object)"IDLE_TTL_KEY");
        eet = region.getEntryExpiryTask((Object)"IDLE_TTL_KEY");
        long secondIdleExpiryTime = eet.getIdleExpirationTime();
        long secondTTLExpiryTime = eet.getTTLExpirationTime();
        Assert.assertEquals((long)firstTTLExpiryTime, (long)secondTTLExpiryTime);
        if (secondIdleExpiryTime - firstIdleExpiryTime <= 0L) {
            Assert.fail((String)("idle should have increased: idle=" + firstIdleExpiryTime + " idle2=" + secondIdleExpiryTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionExpirationAfterMutate() throws CacheException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        factory.setStatisticsEnabled(true);
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long shortExpiryTime;
            LocalRegion region = (LocalRegion)this.createRegion(name, factory);
            region.create((Object)key, (Object)value);
            Region.Entry entry = region.getEntry((Object)key);
            Assert.assertEquals((Object)value, (Object)entry.getValue());
            region.getAttributesMutator().setRegionIdleTimeout(new ExpirationAttributes(12000, ExpirationAction.INVALIDATE));
            region.put((Object)key, (Object)value);
            long tilt = System.currentTimeMillis();
            RegionIdleExpiryTask expiryTask = region.getRegionIdleExpiryTask();
            long mediumExpiryTime = expiryTask.getExpirationTime();
            region.getAttributesMutator().setRegionIdleTimeout(new ExpirationAttributes(999000, ExpirationAction.INVALIDATE));
            expiryTask = region.getRegionIdleExpiryTask();
            long hugeExpiryTime = expiryTask.getExpirationTime();
            ExpiryTask.suspendExpiration();
            try {
                region.getAttributesMutator().setRegionIdleTimeout(new ExpirationAttributes(20, ExpirationAction.INVALIDATE));
                expiryTask = region.getRegionIdleExpiryTask();
                shortExpiryTime = expiryTask.getExpirationTime();
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt + 20L, 10);
            Assert.assertTrue((String)("expected hugeExpiryTime=" + hugeExpiryTime + " to be > than mediumExpiryTime=" + mediumExpiryTime), (hugeExpiryTime - mediumExpiryTime > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("expected mediumExpiryTime=" + mediumExpiryTime + " to be > than shortExpiryTime=" + shortExpiryTime), (mediumExpiryTime - shortExpiryTime > 0L ? 1 : 0) != 0);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    @Test
    public void testRegionIdleInvalidate() throws CacheException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        final String subname = this.getUniqueName() + "-SUB";
        int timeout = 22;
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        vm0.invoke("testRegionIdleInvalidate", new CacheSerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region sub;
                Region.Entry entry;
                long tilt;
                Region region;
                TestCacheListener<Object, Object> list = new TestCacheListener<Object, Object>(){
                    private int createCount = 0;

                    @Override
                    public void afterInvalidate2(EntryEvent e) {
                        e.getRegion().getCache().getLogger().info("invalidate2 key=" + String.valueOf(e.getKey()));
                    }

                    @Override
                    public void afterRegionInvalidate2(RegionEvent e) {
                    }

                    @Override
                    public void afterUpdate2(EntryEvent e) {
                        this.wasInvoked();
                    }

                    @Override
                    public void afterCreate2(EntryEvent e) {
                        ++this.createCount;
                        Assert.assertEquals((long)1L, (long)this.createCount);
                        this.wasInvoked();
                    }
                };
                RegionFactory factory = RegionTestCase.this.getCache().createRegionFactory(RegionTestCase.this.getRegionAttributes());
                ExpirationAttributes expire = new ExpirationAttributes(22, ExpirationAction.INVALIDATE);
                factory.setRegionIdleTimeout(expire);
                factory.setStatisticsEnabled(true);
                factory.addCacheListener((CacheListener)list);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                ExpiryTask.suspendExpiration();
                try {
                    region = RegionTestCase.this.createRegion(name, factory);
                    region.put(key, value);
                    tilt = System.currentTimeMillis() + 22L;
                    entry = region.getEntry(key);
                    Assert.assertEquals((Object)value, (Object)entry.getValue());
                    sub = factory.createSubregion(region, subname);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                    ExpiryTask.permitExpiration();
                }
                RegionTestCase.this.waitForInvalidate(entry, tilt, 10);
                Assert.assertTrue((boolean)list.waitForInvocation(333));
                int EXPIRATION_MS = 9000;
                region.getAttributesMutator().setRegionIdleTimeout(new ExpirationAttributes(9000, ExpirationAction.INVALIDATE));
                LocalRegion lr = (LocalRegion)region;
                RegionIdleExpiryTask expiryTask = lr.getRegionIdleExpiryTask();
                region.put(key, value);
                long createExpiry = expiryTask.getExpirationTime();
                long changeTime = Wait.waitForExpiryClockToChange(lr, createExpiry - 9000L);
                region.put(key, (Object)"VALUE2");
                long putExpiry = expiryTask.getExpirationTime();
                Assert.assertTrue((String)("CLOCK went back in time! Expected putBaseExpiry=" + (putExpiry - 9000L) + " to be >= than changeTime=" + changeTime), (putExpiry - 9000L - changeTime >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)("expected putExpiry=" + putExpiry + " to be > than createExpiry=" + createExpiry), (putExpiry - createExpiry > 0L ? 1 : 0) != 0);
                changeTime = Wait.waitForExpiryClockToChange(lr, putExpiry - 9000L);
                region.get(key);
                long getExpiry = expiryTask.getExpirationTime();
                Assert.assertTrue((String)("CLOCK went back in time! Expected getBaseExpiry=" + (getExpiry - 9000L) + " to be >= than changeTime=" + changeTime), (getExpiry - 9000L - changeTime >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)("expected getExpiry=" + getExpiry + " to be > than putExpiry=" + putExpiry), (getExpiry - putExpiry > 0L ? 1 : 0) != 0);
                changeTime = Wait.waitForExpiryClockToChange(lr, getExpiry - 9000L);
                sub.put(key, value);
                long subPutExpiry = expiryTask.getExpirationTime();
                Assert.assertTrue((String)("CLOCK went back in time! Expected subPutBaseExpiry=" + (subPutExpiry - 9000L) + " to be >= than changeTime=" + changeTime), (subPutExpiry - 9000L - changeTime >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)("expected subPutExpiry=" + subPutExpiry + " to be > than getExpiry=" + getExpiry), (subPutExpiry - getExpiry > 0L ? 1 : 0) != 0);
                changeTime = Wait.waitForExpiryClockToChange(lr, subPutExpiry - 9000L);
                sub.get(key);
                long subGetExpiry = expiryTask.getExpirationTime();
                Assert.assertTrue((String)("CLOCK went back in time! Expected subGetBaseExpiry=" + (subGetExpiry - 9000L) + " to be >= than changeTime=" + changeTime), (subGetExpiry - 9000L - changeTime >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)("expected subGetExpiry=" + subGetExpiry + " to be > than subPutExpiry=" + subPutExpiry), (subGetExpiry - subPutExpiry > 0L ? 1 : 0) != 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionIdleDestroy() throws CacheException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        String name = this.getUniqueName();
        int timeout = 22;
        String key = "KEY";
        String value = "VALUE";
        RegionFactory factory = this.getCache().createRegionFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(22, ExpirationAction.DESTROY);
        factory.setRegionIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        ExpiryTask.suspendExpiration();
        try {
            long tilt;
            Region region;
            System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
            try {
                region = this.createRegion(name, factory);
                region.put((Object)key, (Object)value);
                tilt = System.currentTimeMillis() + 22L;
                Assert.assertFalse((boolean)region.isDestroyed());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForRegionDestroy(region, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshot() throws IOException, CacheException, ClassNotFoundException {
        final String name = this.getUniqueName();
        preSnapshotRegion = this.createRegion(name);
        boolean isDistributed = this.getRegionAttributes().getScope().isDistributed();
        if (isDistributed) {
            Invoke.invokeInEveryVM("create presnapshot region", new CacheSerializableRunnable(){

                @Override
                public void run2() throws CacheException {
                    preSnapshotRegion = RegionTestCase.this.createRegion(name);
                }
            });
        }
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                preSnapshotRegion.create((Object)String.valueOf(i), null);
                continue;
            }
            preSnapshotRegion.create((Object)String.valueOf(i), (Object)i);
        }
        File file = new File(name + ".snap");
        FileOutputStream out = new FileOutputStream(file);
        try {
            preSnapshotRegion.saveSnapshot((OutputStream)out);
            Assert.assertEquals((Object)5, (Object)preSnapshotRegion.get((Object)"5"));
            for (int i = 0; i < 10; ++i) {
                preSnapshotRegion.destroy((Object)String.valueOf(i));
            }
            Assert.assertEquals((long)0L, (long)preSnapshotRegion.keySet().size());
            FileInputStream in = new FileInputStream(file);
            preSnapshotRegion.loadSnapshot((InputStream)in);
            this.remoteTestPostSnapshot(name, true, false);
            if (isDistributed) {
                Invoke.invokeInEveryVM("postSnapshot", new CacheSerializableRunnable(){

                    @Override
                    public void run2() throws CacheException {
                        RegionTestCase.this.remoteTestPostSnapshot(name, false, false);
                    }
                });
            }
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootSnapshot() throws IOException, CacheException, ClassNotFoundException {
        final String name = this.getUniqueName();
        preSnapshotRegion = this.createRootRegion(name, this.getRegionAttributes());
        boolean isDistributed = this.getRegionAttributes().getScope().isDistributed();
        if (isDistributed) {
            Invoke.invokeInEveryVM("create presnapshot region", new CacheSerializableRunnable(){

                @Override
                public void run2() throws CacheException {
                    preSnapshotRegion = RegionTestCase.this.createRootRegion(name, RegionTestCase.this.getRegionAttributes());
                }
            });
        }
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                preSnapshotRegion.create((Object)String.valueOf(i), null);
                continue;
            }
            preSnapshotRegion.create((Object)String.valueOf(i), (Object)i);
        }
        File file = new File(name + ".snap");
        FileOutputStream out = new FileOutputStream(file);
        try {
            preSnapshotRegion.saveSnapshot((OutputStream)out);
            Assertions.assertThat((Object)preSnapshotRegion.get((Object)"5")).isEqualTo((Object)5);
            for (int i = 0; i < 10; ++i) {
                preSnapshotRegion.destroy((Object)String.valueOf(i));
            }
            Assertions.assertThat((int)preSnapshotRegion.keySet().size()).isEqualTo(0);
            FileInputStream in = new FileInputStream(file);
            preSnapshotRegion.loadSnapshot((InputStream)in);
            this.remoteTestPostSnapshot(name, true, true);
            if (isDistributed) {
                Invoke.invokeInEveryVM("postSnapshot", new CacheSerializableRunnable(){

                    @Override
                    public void run2() throws CacheException {
                        RegionTestCase.this.remoteTestPostSnapshot(name, false, true);
                    }
                });
            }
        }
        finally {
            file.delete();
        }
    }

    private void remoteTestPostSnapshot(String name, boolean isController, boolean isRoot) throws CacheException {
        Assert.assertTrue((boolean)preSnapshotRegion.isDestroyed());
        try {
            preSnapshotRegion.get((Object)"0");
            Assert.fail((String)"Should have thrown a RegionReinitializedException");
        }
        catch (RegionReinitializedException regionReinitializedException) {
            // empty catch block
        }
        Region postSnapshotRegion = isRoot ? this.getRootRegion(name) : this.getRootRegion().getSubregion(name);
        Assert.assertNotNull((String)"Could not get reference to reinitialized region", (Object)postSnapshotRegion);
        boolean expectData = isController || postSnapshotRegion.getAttributes().getMirrorType().isMirrored() || postSnapshotRegion.getAttributes().getDataPolicy().isPreloaded();
        Assert.assertEquals((long)(expectData ? 10L : 0L), (long)postSnapshotRegion.keySet().size());
        Assert.assertEquals((Object)3, (Object)postSnapshotRegion.get((Object)"3"));
        if (expectData) {
            Assert.assertFalse((boolean)postSnapshotRegion.containsValueForKey((Object)"9"));
            Assert.assertTrue((boolean)postSnapshotRegion.containsKey((Object)"9"));
        }
    }

    static class TestExpiry<K, V>
    implements CustomExpiry<K, V>,
    Declarable {
        final String special;
        final ExpirationAttributes specialAtt;

        TestExpiry(String flagged, ExpirationAttributes att) {
            this.special = flagged;
            this.specialAtt = att;
        }

        public ExpirationAttributes getExpiry(Region.Entry entry) {
            if (entry.getKey().equals(this.special)) {
                return this.specialAtt;
            }
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    private static class TestCacheListenerCustom
    extends TestCacheListener<Object, Object> {
        private TestCacheListenerCustom() {
        }

        @Override
        public void afterCreate2(EntryEvent e) {
        }

        @Override
        public void afterUpdate2(EntryEvent e) {
        }

        @Override
        public void afterInvalidate2(EntryEvent e) {
        }
    }

    private class TestCacheListenerEventCount
    extends TestCacheListenerCustom {
        private TestCacheListenerEventCount() {
        }

        @Override
        public void afterInvalidate2(EntryEvent e) {
            RegionTestCase.this.eventCount.incrementAndGet();
        }
    }

    static class CountExpiry<K, V>
    implements CustomExpiry<K, V>,
    Declarable {
        static final HashMap<Object, Object> invokeCounts = new HashMap();
        final String special;
        final ExpirationAttributes specialAtt;

        CountExpiry(String flagged, ExpirationAttributes att) {
            this.special = flagged;
            this.specialAtt = att;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            Object key = entry.getKey();
            Class<CountExpiry> clazz = CountExpiry.class;
            synchronized (CountExpiry.class) {
                Integer count = (Integer)invokeCounts.get(key);
                if (count == null) {
                    invokeCounts.put(key, 1);
                } else {
                    invokeCounts.put(key, count + 1);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (key.equals(this.special)) {
                    return this.specialAtt;
                }
                return null;
            }
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    class ExpiryCallbacks
    implements ExpiryTask.ExpiryTaskListener {
        ExpiryCallbacks() {
        }

        public void afterCancel(ExpiryTask et) {
            RegionTestCase.this.getCache().getLogger().info("ExpiryCallbacks.afterCancel", (Throwable)new RuntimeException("TaskCanceled"));
        }

        public void afterSchedule(ExpiryTask et) {
            this.printState(et, "ExpiryCallbacks.afterSchedule ");
        }

        public void afterTaskRan(ExpiryTask et) {
            this.printState(et, "ExpiryCallbacks.afterTaskRan ");
        }

        void printState(ExpiryTask et, String callback) {
            Date now;
            Date ttl = now = new Date();
            try {
                ttl = new Date(et.getExpirationTime());
            }
            catch (EntryNotFoundException entryNotFoundException) {
                // empty catch block
            }
            Date idleExpTime = now;
            try {
                idleExpTime = new Date(et.getIdleExpirationTime());
            }
            catch (EntryNotFoundException entryNotFoundException) {
                // empty catch block
            }
            Date ttlTime = new Date(et.getTTLExpirationTime());
            Date getNow = new Date(et.calculateNow());
            Date scheduleETime = new Date(et.scheduledExecutionTime());
            RegionTestCase.this.getCache().getLogger().info(callback + " now: " + this.getCurrentTimeStamp(now) + " ttl:" + this.getCurrentTimeStamp(ttl) + " idleExpTime:" + this.getCurrentTimeStamp(idleExpTime) + " ttlTime:" + this.getCurrentTimeStamp(ttlTime) + " getNow:" + this.getCurrentTimeStamp(getNow) + " scheduleETime:" + this.getCurrentTimeStamp(scheduleETime) + " getKey:" + String.valueOf(et.getKey()) + " isPending:" + et.isPending() + " et :" + String.valueOf(et) + " Task reference " + System.identityHashCode(et));
        }

        String getCurrentTimeStamp(Date d) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(d);
        }

        public void afterReschedule(ExpiryTask et) {
            this.printState(et, "ExpiryCallbacks.afterReschedule");
        }

        public void afterExpire(ExpiryTask et) {
            this.printState(et, "ExpiryCallbacks.afterExpire");
        }
    }
}

