/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.Jitter;
import org.apache.geode.test.dunit.VM;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class ThreadUtils {
    private static final Logger logger = LogService.getLogger();

    protected ThreadUtils() {
    }

    public static void dumpAllStacks() {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            ThreadUtils.dumpStack(Host.getHost(h));
        }
    }

    public static void dumpMyThreads() {
        OSProcess.printStacks((int)0, (boolean)false);
    }

    public static void dumpStack() {
        OSProcess.printStacks((int)0, (boolean)false);
    }

    public static void dumpStack(Host host) {
        for (int v = 0; v < host.getVMCount(); ++v) {
            host.getVM(v).invoke(ThreadUtils.class, "dumpStack");
        }
    }

    public static void dumpStack(VM vm) {
        vm.invoke(ThreadUtils.class, "dumpStack");
    }

    public static void dumpStackTrace(Thread thread, StackTraceElement[] stackTrace) {
        StringBuilder msg = new StringBuilder();
        msg.append("Thread=<").append(thread).append("> stackDump:\n");
        for (int i = 0; i < stackTrace.length; ++i) {
            msg.append("\t").append(stackTrace[i]).append("\n");
        }
        logger.info(msg.toString());
    }

    public static void join(AsyncInvocation<?> async, long timeoutMilliseconds) {
        ThreadUtils.join(async.getThread(), timeoutMilliseconds);
    }

    public static void join(Thread thread, long timeoutMilliseconds) {
        long elapsedMs;
        long tilt = System.currentTimeMillis() + timeoutMilliseconds;
        long incrementalWait = Jitter.jitterInterval(timeoutMilliseconds);
        long start = System.currentTimeMillis();
        while (thread.isAlive()) {
            try {
                thread.join(incrementalWait);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"interrupted");
            }
            if (System.currentTimeMillis() < tilt) continue;
        }
        if (thread.isAlive()) {
            logger.info("HUNG THREAD");
            ThreadUtils.dumpStackTrace(thread, thread.getStackTrace());
            ThreadUtils.dumpMyThreads();
            thread.interrupt();
            Assert.fail((String)("Thread did not terminate after " + timeoutMilliseconds + " ms: " + thread));
        }
        if ((elapsedMs = System.currentTimeMillis() - start) > 0L) {
            String msg = "Thread " + thread + " took " + elapsedMs + " ms to exit.";
            logger.info(msg);
        }
    }
}

