/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.standalone;

import java.rmi.Naming;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVM;
import org.apache.geode.test.dunit.standalone.VersionManager;
import org.apache.logging.log4j.Logger;

public class ChildVM {
    private static boolean stopMainLoop = false;
    private static final Logger logger = LogService.getLogger();

    public static void stopVM() {
        stopMainLoop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        try {
            int namingPort = Integer.getInteger("gemfire.DUnitLauncher.RMI_PORT");
            int vmNum = Integer.getInteger("gemfire.DUnitLauncher.VM_NUM");
            String geodeVersion = System.getProperty("gemfire.DUnitLauncher.VM_VERSION");
            int pid = OSProcess.getId();
            logger.info("VM" + vmNum + " is launching" + (pid > 0 ? " with PID " + pid : ""));
            if (!VersionManager.isCurrentVersion((String)geodeVersion)) {
                logger.info("This VM is using Geode version {}. Version.CURRENT is {} (ordinal={})", (Object)geodeVersion, (Object)Version.CURRENT, (Object)Version.CURRENT_ORDINAL);
            }
            DUnitLauncher.MasterRemote holder = (DUnitLauncher.MasterRemote)Naming.lookup("//localhost:" + namingPort + "/" + "DUNIT_MASTER");
            DUnitLauncher.init(holder);
            DUnitLauncher.locatorPort = holder.getLocatorPort();
            RemoteDUnitVM dunitVM = new RemoteDUnitVM();
            String name = "//localhost:" + namingPort + "/vm" + vmNum;
            Naming.rebind(name, dunitVM);
            JUnit4DistributedTestCase.initializeBlackboard();
            holder.signalVMReady();
            while (!stopMainLoop) {
                holder.ping();
                Thread.sleep(1000L);
            }
        }
        catch (Throwable t) {
            logger.info("VM is exiting with error", t);
            ExitCode.FATAL.doSystemExit();
        }
        finally {
            logger.info("VM is exiting");
        }
    }
}

