/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.hamcrest.Matcher;
import org.junit.rules.ErrorCollector;

public class SharedErrorCollector
extends AbstractDistributedRule {
    private static volatile ProtectedErrorCollector errorCollector;

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(() -> {
            errorCollector = new ProtectedErrorCollector();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void after() throws Throwable {
        ProtectedErrorCollector allErrors = errorCollector;
        try {
            for (VM vm : VM.getAllVMs()) {
                ArrayList remoteFailures = new ArrayList();
                remoteFailures.addAll((Collection)vm.invoke(() -> errorCollector.errors()));
                for (Throwable t : remoteFailures) {
                    allErrors.addError(t);
                }
            }
            this.invoker().invokeInEveryVMAndController(() -> {
                errorCollector = null;
            });
        }
        finally {
            allErrors.verify();
        }
    }

    public void addError(Throwable error) {
        errorCollector.addError(error);
    }

    public <T> void checkThat(T value, Matcher<T> matcher) {
        errorCollector.checkThat(value, matcher);
    }

    public <T> void checkThat(String reason, T value, Matcher<T> matcher) {
        errorCollector.checkThat(reason, value, matcher);
    }

    public <T> T checkSucceeds(Callable<T> callable) {
        return (T)errorCollector.checkSucceeds(callable);
    }

    private static class ProtectedErrorCollector
    extends ErrorCollector {
        private final List<Throwable> protectedErrors;

        ProtectedErrorCollector() {
            try {
                Field superErrors = ErrorCollector.class.getDeclaredField("errors");
                superErrors.setAccessible(true);
                this.protectedErrors = (List)superErrors.get((Object)this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        List<Throwable> errors() {
            return this.protectedErrors;
        }

        public void verify() throws Throwable {
            super.verify();
        }
    }
}

